# 📱 Facebook Messenger Entegrasyonu

## 🎯 Genel Bakış
Facebook Messenger üzerinden gelen mesajları CRM'de yönetin.

---

## 📋 Gereksinimler

### 1. Facebook Sayfası
- Aktif bir Facebook Business Sayfası
- Sayfa yönetici yetkisi

### 2. Facebook Developer Hesabı
- https://developers.facebook.com/
- Uygulama oluşturma yetkisi

---

## 🔧 Kurulum Adımları

### **ADIM 1: Facebook Developer Console**

1. **https://developers.facebook.com/** adresine gidin
2. **"My Apps"** → **"Create App"** tıklayın
3. **App Type:** "Business" seçin
4. **App Name:** "Profaj CRM Messenger"
5. **App Contact Email:** E-posta adresinizi girin
6. **Create App** tıklayın

---

### **ADIM 2: Messenger Ürününü Ekleyin**

1. Sol menüden **"Add Products"** tıklayın
2. **"Messenger"** bulun ve **"Set Up"** tıklayın
3. **"Messenger Settings"** sayfası açılacak

---

### **ADIM 3: Access Token Alın**

1. **Messenger Settings** sayfasında:
   - **"Access Tokens"** bölümünü bulun
   - **"Add or Remove Pages"** tıklayın
   - Facebook Sayfanızı seçin ve izinleri onaylayın
   
2. **"Generate Token"** tıklayın
3. Token'ı kopyalayın ve güvenli bir yere kaydedin

```
Örnek Token:
EAAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
```

---

### **ADIM 4: Webhook Kurulumu**

1. **Messenger Settings** → **"Webhooks"** bölümüne gidin
2. **"Add Callback URL"** tıklayın

**Webhook Bilgileri:**
```
Callback URL: https://profaj.co/multicrm/api/webhook-facebook.php
Verify Token: profaj_whatsapp_2024
```

3. **"Verify and Save"** tıklayın

---

### **ADIM 5: Webhook Events Subscribe**

Aşağıdaki event'leri **mutlaka** seçin:

```
✅ messages                 (Gelen mesajlar)
✅ messaging_postbacks      (Buton tıklamaları)
✅ message_deliveries       (Mesaj iletildi bildirimleri)
✅ message_reads            (Mesaj okundu bildirimleri)
```

**NOT:** `leadgen` seçmeyin (Lead Ads kullanmıyoruz)

---

### **ADIM 6: Sayfayı Subscribe Edin**

1. **Webhooks** bölümünde sayfanızı bulun
2. **"Subscribe"** butonuna tıklayın
3. Yukarıdaki event'lerin seçili olduğundan emin olun

---

### **ADIM 7: CRM Ayarları**

1. **CRM'e giriş yapın:** https://profaj.co/multicrm/
2. **"Ayarlar"** sekmesine gidin
3. **Facebook Messenger** bölümünü bulun
4. Aşağıdaki bilgileri girin:

```
Page Access Token: [ADIM 3'te aldığınız token]
Verify Token: profaj_whatsapp_2024
Webhook URL: https://profaj.co/multicrm/api/webhook-facebook.php
```

5. **"Kaydet"** tıklayın

---

### **ADIM 8: Uygulamayı Canlıya Alın**

⚠️ **ÖNEMLİ:** Geliştirme modunda sadece siz mesaj gönderebilirsiniz!

1. Facebook Developer Console'da:
   - Sol üst köşede **"App Mode: Development"** yazısını bulun
   - **"Switch Mode"** tıklayın
   - **"Switch to Live Mode"** onaylayın

2. **App Review** gerekebilir:
   - **"App Review"** → **"Permissions and Features"**
   - **"pages_messaging"** iznini isteyin
   - Facebook incelemesi 1-7 gün sürebilir

---

## 🧪 Test Etme

### **1. Webhook Doğrulama**
Tarayıcıda açın:
```
https://profaj.co/multicrm/api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123
```

**Beklenen Sonuç:** `test123`

---

### **2. Mesaj Gönderme Testi**

1. Facebook Sayfanızın **Messenger'ına** gidin
2. Kendinize bir mesaj gönderin: "Merhaba test"
3. CRM'de kontrol edin:
   - **"Sohbetler"** sekmesinde yeni sohbet görünmeli
   - **"Müşteriler"** sekmesinde yeni müşteri görünmeli

---

### **3. Log Kontrolü**

Sorun yaşarsanız log dosyasını kontrol edin:
```
/Users/emre/Desktop/multicrm/logs/facebook_webhook_[TARIH].log
```

---

## 📊 Nasıl Çalışır?

### **Gelen Mesaj Akışı:**

```
1. Müşteri Facebook Messenger'dan mesaj gönderir
2. Facebook webhook'u tetikler
3. webhook-facebook.php mesajı alır
4. Müşteri yoksa oluşturulur
5. Sohbet yoksa oluşturulur
6. Mesaj veritabanına kaydedilir
7. CRM'de gerçek zamanlı görünür
```

### **Giden Mesaj Akışı:**

```
1. Agent CRM'den mesaj yazar
2. send-facebook-message.php API'ye gönderir
3. Facebook Graph API'ye POST request
4. Müşteriye Messenger'dan mesaj iletilir
5. Delivery/Read durumları webhook'tan gelir
```

---

## 🔑 API Bilgileri

### **Webhook URL:**
```
https://profaj.co/multicrm/api/webhook-facebook.php
```

### **Verify Token:**
```
profaj_whatsapp_2024
```

### **Graph API Version:**
```
v18.0
```

### **Send Message Endpoint:**
```
POST https://graph.facebook.com/v18.0/me/messages
```

---

## ❓ Sık Sorulan Sorular

### **Q: Mesajlar CRM'e gelmiyor**
A: 
1. Webhook URL'i doğru mu kontrol edin
2. Verify Token eşleşiyor mu kontrol edin
3. Event subscription'ları kontrol edin (messages seçili mi?)
4. Sayfa subscribe edilmiş mi kontrol edin
5. Log dosyasını kontrol edin

### **Q: Mesaj gönderemiyorum**
A:
1. Page Access Token doğru mu kontrol edin
2. Token'ın süresi dolmuş olabilir (yenileyin)
3. Uygulama Live modda mı kontrol edin
4. pages_messaging izni var mı kontrol edin

### **Q: Sadece benim mesajlarım geliyor**
A: Uygulama Development modunda. Live moda geçin.

### **Q: App Review ne kadar sürer?**
A: Genellikle 1-7 gün. Bazen 24 saat içinde onaylanır.

---

## 🆘 Destek

Sorun yaşarsanız:
1. Log dosyasını kontrol edin
2. Facebook Developer Console → App Dashboard → Webhooks → Test Events
3. CRM Ayarlar sayfasında "Test Bağlantı" butonunu kullanın

---

## ✅ Checklist

Kurulum tamamlandığında:

- [ ] Facebook Developer App oluşturuldu
- [ ] Messenger ürünü eklendi
- [ ] Page Access Token alındı
- [ ] Webhook URL eklendi ve doğrulandı
- [ ] Webhook events subscribe edildi (messages, messaging_postbacks)
- [ ] Sayfa webhook'a subscribe edildi
- [ ] CRM ayarlarına token eklendi
- [ ] Webhook doğrulama testi başarılı
- [ ] Test mesajı gönderildi ve CRM'de görüldü
- [ ] CRM'den mesaj gönderme testi yapıldı
- [ ] Uygulama Live moda alındı (opsiyonel, test için gerekli değil)

---

**🎉 Kurulum Tamamlandı!**

Artık Facebook Messenger üzerinden müşterilerinizle CRM'den iletişim kurabilirsiniz.

