# MultiCRM - WhatsApp CRM Sistemi

MultiCRM, WhatsApp üzerinden müşteri destek hizmeti sunan modern bir CRM sistemidir. Chatwoot benzeri özellikler sunar ve PHP ile geliştirilmiştir.

## 🚀 Özellikler

- **WhatsApp Entegrasyonu**: Gerçek zamanlı WhatsApp mesajlaşması
- **Canlı Sohbet**: Müşterilerle anlık mesajlaşma
- **Müşteri Yönetimi**: Müşteri bilgileri ve geçmiş takibi
- **Çoklu Kullanıcı**: Ajans bazlı kullanıcı yönetimi
- **Mesaj Geçmişi**: Tüm konuşmaların saklanması
- **Gerçek Zamanlı**: Anlık mesaj bildirimleri
- **Responsive Tasarım**: Mobil uyumlu arayüz

## 📋 Gereksinimler

- PHP 7.4 veya üzeri
- MySQL 5.7 veya üzeri
- cURL desteği
- SSL sertifikası (WhatsApp webhook için)

## 🛠️ Kurulum

### 1. Dosyaları Yükleyin

Tüm dosyaları cPanel File Manager ile `public_html/multicrm/` dizinine yükleyin.

### 2. Veritabanını Kurun

1. cPanel'de MySQL Database oluşturun:
   - Database Name: `profajco_multicrm`
   - Username: `profajco_multicrm`
   - Password: `multi@@2025`

2. Tarayıcıda `https://profaj.co/multicrm/install/install.php` adresine gidin
3. Kurulum tamamlanana kadar bekleyin

### 3. WhatsApp API Ayarları

1. Facebook Developer Console'da WhatsApp Business API hesabı oluşturun
2. Aşağıdaki bilgileri WhatsApp Developer Console'da ayarlayın:

**Webhook Ayarları:**
- Webhook URL: `https://profaj.co/multicrm/api/webhook-whatsapp.php`
- Verify Token: `profaj_whatsapp_2024`

**API Bilgileri:**
- Phone Number ID: `592915763902531`
- Business Account ID: `1368891014268764`
- Access Token: `EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e`
- API Version: `v18.0`

### 4. İlk Giriş

1. `https://profaj.co/multicrm/login.php` adresine gidin
2. Varsayılan giriş bilgileri:
   - Email: `admin@multicrm.com`
   - Şifre: `password`

## 📱 Kullanım

### Müşteri Ekleme
1. "Müşteriler" sayfasından yeni müşteri ekleyin
2. Telefon numarası ve ad bilgilerini girin
3. Müşteri otomatik olarak sisteme kaydedilir

### Sohbet Başlatma
1. Ana sayfada "Yeni Sohbet" butonuna tıklayın
2. Müşteri telefon numarasını girin
3. Sohbet otomatik olarak başlar

### Mesaj Gönderme
1. Aktif sohbeti seçin
2. Mesajınızı yazın ve Enter tuşuna basın
3. Mesaj WhatsApp'a gönderilir

## 🔧 Yapılandırma

### Veritabanı Ayarları
`config/database.php` dosyasında veritabanı bilgilerini güncelleyin:

```php
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];
```

### WhatsApp API Ayarları
`config/database.php` dosyasında WhatsApp API bilgilerini güncelleyin:

```php
$whatsapp_config = [
    'phone_number_id' => 'YOUR_PHONE_NUMBER_ID',
    'business_account_id' => 'YOUR_BUSINESS_ACCOUNT_ID',
    'access_token' => 'YOUR_ACCESS_TOKEN',
    'api_version' => 'v18.0',
    'verify_token' => 'profaj_whatsapp_2024'
];
```

## 📁 Proje Yapısı

```
multicrm/
├── api/                    # API dosyaları
│   ├── webhook-whatsapp.php
│   ├── send-message.php
│   ├── get-messages.php
│   └── ...
├── assets/                 # CSS, JS, resimler
│   ├── css/style.css
│   └── js/app.js
├── config/                 # Yapılandırma dosyaları
│   └── database.php
├── includes/               # Yardımcı dosyalar
│   └── functions.php
├── install/                # Kurulum dosyaları
│   ├── database.sql
│   └── install.php
├── logs/                   # Log dosyaları
├── index.php              # Ana sayfa
├── login.php              # Giriş sayfası
├── customers.php          # Müşteriler sayfası
├── settings.php           # Ayarlar sayfası
└── README.md
```

## 🔒 Güvenlik

- Tüm kullanıcı girişleri doğrulanır
- SQL injection koruması (PDO prepared statements)
- XSS koruması (htmlspecialchars)
- CSRF koruması (session token)
- Şifreler hash'lenerek saklanır

## 📊 Veritabanı Tabloları

- `users`: Kullanıcı bilgileri
- `customers`: Müşteri bilgileri
- `conversations`: Sohbet kayıtları
- `messages`: Mesaj kayıtları
- `agencies`: Ajans bilgileri
- `settings`: Sistem ayarları
- `webhook_logs`: Webhook logları

## 🐛 Sorun Giderme

### Webhook Çalışmıyor
1. SSL sertifikasının aktif olduğunu kontrol edin
2. Webhook URL'nin doğru olduğunu kontrol edin
3. Verify token'ın eşleştiğini kontrol edin

### Mesajlar Gönderilmiyor
1. WhatsApp API token'ının geçerli olduğunu kontrol edin
2. Phone Number ID'nin doğru olduğunu kontrol edin
3. API rate limit'ini kontrol edin

### Veritabanı Bağlantı Hatası
1. Veritabanı bilgilerini kontrol edin
2. MySQL servisinin çalıştığını kontrol edin
3. Kullanıcı yetkilerini kontrol edin

## 📞 Destek

Herhangi bir sorun yaşarsanız:
1. Log dosyalarını kontrol edin (`logs/` dizini)
2. Hata mesajlarını not alın
3. Sistem ayarlarını kontrol edin

## 📄 Lisans

Bu proje MIT lisansı altında lisanslanmıştır.

## 🔄 Güncellemeler

- v1.0.0: İlk sürüm
- WhatsApp entegrasyonu
- Temel CRM özellikleri
- Çoklu kullanıcı desteği
