<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🎯 Reklam Ekibi İçin Facebook App Review</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #ff2400 0%, #f97316 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1100px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        .header h1 {
            color: #ff2400;
            font-size: 42px;
            margin-bottom: 10px;
        }
        .header p {
            color: #666;
            font-size: 20px;
        }
        .urgent-box {
            background: linear-gradient(135deg, #ff2400 0%, #f97316 100%);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin: 30px 0;
            text-align: center;
        }
        .urgent-box h2 {
            font-size: 28px;
            margin-bottom: 15px;
        }
        .section {
            margin: 30px 0;
            padding: 25px;
            background: #f8f9fa;
            border-radius: 12px;
        }
        .section h3 {
            color: #ff2400;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin: 20px 0;
        }
        .info-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .info-card h4 {
            color: #ff2400;
            margin-bottom: 10px;
        }
        .code-box {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
            font-size: 14px;
            line-height: 1.6;
        }
        .checklist {
            list-style: none;
            padding: 0;
        }
        .checklist li {
            padding: 15px;
            margin: 10px 0;
            background: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .checklist li::before {
            content: "☐";
            font-size: 28px;
            margin-right: 15px;
            color: #ff2400;
        }
        .btn {
            display: inline-block;
            padding: 18px 40px;
            background: linear-gradient(135deg, #ff2400 0%, #f97316 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-weight: bold;
            font-size: 18px;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(255, 36, 0, 0.3);
        }
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(255, 36, 0, 0.4);
        }
        .warning {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .success {
            background: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .step-number {
            display: inline-block;
            background: linear-gradient(135deg, #ff2400 0%, #f97316 100%);
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            text-align: center;
            line-height: 40px;
            font-weight: bold;
            margin-right: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎯 Reklam Ekibi İçin</h1>
            <p>Facebook App Review Başvuru Bilgileri</p>
        </div>

        <div class="urgent-box">
            <h2>⚡ ÖNEMLİ BİLGİ</h2>
            <p style="font-size: 18px; margin-top: 10px;">
                CRM sistemi hazır! Reklam ekibi Facebook App Review başvurusunu yaptığında,<br>
                onay gelir gelmez otomatik olarak Facebook'tan kullanıcı isimleri çekilecek.
            </p>
        </div>

        <div class="section">
            <h3>📋 Başvuru İçin Gerekli Bilgiler</h3>
            
            <div class="info-grid">
                <div class="info-card">
                    <h4>🌐 CRM URL</h4>
                    <div class="code-box">https://profaj.co/multicrm/</div>
                </div>
                
                <div class="info-card">
                    <h4>🔗 Webhook URL</h4>
                    <div class="code-box">https://profaj.co/multicrm/api/webhook-facebook.php</div>
                </div>
                
                <div class="info-card">
                    <h4>📘 Facebook Page</h4>
                    <div class="code-box">[Profaj Facebook Sayfası]</div>
                </div>
                
                <div class="info-card">
                    <h4>🎯 İzin Adı</h4>
                    <div class="code-box">pages_messaging</div>
                </div>
            </div>
        </div>

        <div class="section">
            <h3>📝 Başvuru Formu İçin Metinler</h3>
            
            <h4 style="margin: 20px 0 10px 0;"><span class="step-number">1</span> App Description (İngilizce)</h4>
            <div class="code-box">MultiCRM is a customer relationship management system that helps businesses manage customer conversations from Facebook Messenger.

We need pages_messaging permission to:
• Receive messages from customers
• Send responses to customers  
• Retrieve customer profile information (name) for personalized service
• Manage customer conversations efficiently

Our system helps businesses provide better customer support by organizing all customer messages in one centralized platform.</div>

            <h4 style="margin: 20px 0 10px 0;"><span class="step-number">2</span> How will you use this permission? (İngilizce)</h4>
            <div class="code-box">We use pages_messaging to:

1. Receive incoming messages from Facebook Messenger users
2. Retrieve user profile information (first_name, last_name) to personalize conversations and identify customers
3. Send automated welcome messages and manual responses to customer inquiries
4. Manage customer support conversations through our CRM interface
5. Track conversation history for better customer service

The user's name is displayed in our CRM interface so our support team can provide personalized assistance.</div>

            <h4 style="margin: 20px 0 10px 0;"><span class="step-number">3</span> Test Instructions (İngilizce)</h4>
            <div class="code-box">HOW TO TEST:

1. Go to our Facebook Page: [Profaj Facebook Page URL]
2. Send a message via Facebook Messenger (e.g., "Hello")
3. Login to CRM: https://profaj.co/multicrm/
   Username: [test kullanıcı adı]
   Password: [test şifresi]
4. See the message appear in CRM with user's name
5. Click on the conversation to view details
6. Type a reply and send it from CRM
7. Check Facebook Messenger to see the reply

EXPECTED RESULT:
- User's name should be visible in CRM (retrieved from Facebook)
- Messages should sync in real-time
- Replies from CRM should appear in Facebook Messenger</div>
        </div>

        <div class="section">
            <h3>✅ Başvuru Öncesi Kontrol Listesi</h3>
            
            <ul class="checklist">
                <li>Facebook Business hesabı aktif</li>
                <li>Facebook Page oluşturulmuş ve yayında</li>
                <li>Facebook App oluşturulmuş</li>
                <li>Webhook bağlantısı test edilmiş ve çalışıyor</li>
                <li>CRM sistemi erişilebilir ve çalışıyor</li>
                <li>Test kullanıcı hesabı hazır</li>
                <li>Privacy Policy sayfası mevcut</li>
                <li>Ekran görüntüleri ve demo video hazır</li>
            </ul>
        </div>

        <div class="section">
            <h3>🎬 Demo Video İçin Senaryo</h3>
            
            <p style="margin-bottom: 15px;"><strong>Video süresi: 1-2 dakika</strong></p>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 1 (15 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">Facebook sayfasını aç, Messenger'dan "Merhaba" mesajı gönder</p>
            </div>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 2 (20 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">CRM'e giriş yap (https://profaj.co/multicrm/)</p>
            </div>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 3 (20 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">Mesajın CRM'de göründüğünü göster - <strong>KULLANICI İSMİNİN GÖRÜNÜYOR OLMASINI VURGULA</strong></p>
            </div>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 4 (15 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">Sohbete tıkla, müşteri bilgilerini göster</p>
            </div>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 5 (20 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">CRM'den cevap yaz ve gönder</p>
            </div>
            
            <div style="background: white; padding: 20px; border-radius: 10px; margin: 15px 0;">
                <p><strong>Sahne 6 (10 saniye):</strong></p>
                <p style="margin-left: 20px; color: #666;">Facebook Messenger'da cevabın geldiğini göster</p>
            </div>
        </div>

        <div class="warning">
            <strong>⚠️ ÖNEMLİ NOTLAR:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>Video'da mutlaka kullanıcı isminin CRM'de göründüğünü vurgulayın</li>
                <li>Webhook URL'i başvuru sırasında çalışır durumda olmalı</li>
                <li>Test kullanıcı bilgilerini Facebook'a vermelisiniz</li>
                <li>Privacy Policy ve Terms of Service linkleri gerekli</li>
            </ul>
        </div>

        <div class="success">
            <strong>✅ SİSTEM DURUMU:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li><strong>Webhook:</strong> Hazır ve çalışıyor ✅</li>
                <li><strong>CRM:</strong> Aktif ve erişilebilir ✅</li>
                <li><strong>Otomatik İsim Çekme:</strong> Kod hazır, App Review onayı bekleniyor ⏳</li>
                <li><strong>Yedek Sistem:</strong> Akıllı isim sorgulama aktif (App Review onaylanana kadar) ✅</li>
            </ul>
        </div>

        <div style="text-align: center; margin-top: 40px;">
            <a href="https://developers.facebook.com/apps/" target="_blank" class="btn">
                🚀 Facebook Developers Console
            </a>
            <a href="facebook-app-review-guide.php" class="btn" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                📖 Detaylı Rehber
            </a>
        </div>

        <div style="margin-top: 40px; padding: 30px; background: #f8f9fa; border-radius: 12px; text-align: center;">
            <h3 style="color: #ff2400; margin-bottom: 15px;">📞 Destek</h3>
            <p style="color: #666; font-size: 16px;">
                Başvuru sırasında herhangi bir sorun yaşarsanız veya ek bilgiye ihtiyaç duyarsanız,<br>
                teknik ekiple iletişime geçin. Sistem hazır, sadece Facebook onayı bekliyoruz!
            </p>
        </div>
    </div>
</body>
</html>

