<?php
/**
 * Facebook Ayarlarını Veritabanına Ekle
 */

require_once 'config/database.php';

echo "<h1>Facebook Ayarları Ekleniyor...</h1>";

try {
    // Facebook ayarlarını ekle
    $settings = [
        [
            'key' => 'facebook_page_id',
            'value' => '',
            'type' => 'string',
            'description' => 'Facebook Sayfa ID'
        ],
        [
            'key' => 'facebook_page_access_token',
            'value' => '',
            'type' => 'string',
            'description' => 'Facebook Sayfa Erişim Token'
        ],
        [
            'key' => 'facebook_app_id',
            'value' => '',
            'type' => 'string',
            'description' => 'Facebook App ID'
        ],
        [
            'key' => 'facebook_app_secret',
            'value' => '',
            'type' => 'string',
            'description' => 'Facebook App Secret'
        ],
        [
            'key' => 'facebook_verify_token',
            'value' => 'profaj_facebook_2024',
            'type' => 'string',
            'description' => 'Facebook Webhook Doğrulama Token'
        ],
        [
            'key' => 'facebook_webhook_url',
            'value' => 'https://profaj.co/multicrm/api/webhook-facebook.php',
            'type' => 'string',
            'description' => 'Facebook Webhook URL'
        ]
    ];

    foreach ($settings as $setting) {
        // Önce var mı kontrol et
        $stmt = $pdo->prepare("SELECT id FROM settings WHERE `key` = ?");
        $stmt->execute([$setting['key']]);
        $exists = $stmt->fetch();

        if ($exists) {
            echo "<p>⚠️ <strong>" . htmlspecialchars($setting['key']) . "</strong> zaten var, atlanıyor...</p>";
        } else {
            $stmt = $pdo->prepare("
                INSERT INTO settings (`key`, `value`, `type`, `description`, created_at, updated_at) 
                VALUES (?, ?, ?, ?, NOW(), NOW())
            ");
            $stmt->execute([
                $setting['key'],
                $setting['value'],
                $setting['type'],
                $setting['description']
            ]);
            echo "<p>✅ <strong>" . htmlspecialchars($setting['key']) . "</strong> eklendi</p>";
        }
    }

    echo "<hr>";
    echo "<h2>✅ Facebook Ayarları Başarıyla Eklendi!</h2>";
    echo "<p><strong>Şimdi ne yapmalısınız?</strong></p>";
    echo "<ol>";
    echo "<li><a href='settings.php'>Ayarlar sayfasına</a> gidin</li>";
    echo "<li>Facebook ayarlarını doldurun:";
    echo "<ul>";
    echo "<li><strong>Facebook Page ID:</strong> Sayfanızın ID'si</li>";
    echo "<li><strong>Facebook Page Access Token:</strong> Sayfa erişim token'ı</li>";
    echo "<li><strong>Facebook App ID:</strong> Uygulama ID'si</li>";
    echo "<li><strong>Facebook App Secret:</strong> Uygulama gizli anahtarı</li>";
    echo "</ul>";
    echo "</li>";
    echo "<li>Facebook Developer Console'da webhook'u ayarlayın:";
    echo "<ul>";
    echo "<li><strong>Webhook URL:</strong> <code>https://profaj.co/multicrm/api/webhook-facebook.php</code></li>";
    echo "<li><strong>Verify Token:</strong> <code>profaj_facebook_2024</code></li>";
    echo "<li><strong>Subscribe Fields:</strong> messages, leadgen</li>";
    echo "</ul>";
    echo "</li>";
    echo "</ol>";

    echo "<hr>";
    echo "<p><a href='settings.php'>→ Ayarlar Sayfasına Git</a></p>";

} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Hata: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>

