<?php
/**
 * Assign Conversation API
 * Manually assign a conversation to an agent
 */

header('Content-Type: application/json');
session_start();

require_once '../config/database.php';
require_once '../includes/functions.php';
require_once '../includes/assignment-engine.php';

// Check authentication
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$user = getUserById($user_id);

// Check permission (only admin and supervisor can assign)
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Permission denied']);
    exit;
}

// Get POST data
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['conversation_id']) || !isset($input['agent_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing required fields']);
    exit;
}

$conversation_id = (int)$input['conversation_id'];
$agent_id = (int)$input['agent_id'];

try {
    // Get assignment engine
    $engine = getAssignmentEngine();
    
    // Assign conversation
    $success = $engine->assignConversation($conversation_id, $agent_id, 'manual');
    
    if ($success) {
        // Get conversation details
        $conversation = getConversationById($conversation_id);
        
        echo json_encode([
            'success' => true,
            'message' => 'Conversation assigned successfully',
            'conversation' => $conversation
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Failed to assign conversation']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
