<?php
/**
 * Zamanlama Kontrolü API
 * Sohbetin AI'nın aktif olup olmayacağını kontrol eder
 */

session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $conversation_id = $input['conversation_id'] ?? 0;
    
    // Aktif chatbot var mı kontrol et
    $stmt = $pdo->query("SELECT id FROM chatbots WHERE is_active = 1 LIMIT 1");
    $active_chatbot = $stmt->fetch();
    
    if (!$active_chatbot) {
        echo json_encode([
            'success' => true,
            'should_be_active' => false,
            'reason' => 'no_active_chatbot'
        ]);
        exit();
    }
    
    // Sohbetin chatbot'unu al
    $stmt = $pdo->prepare("
        SELECT c.chatbot_id, cb.schedule_enabled, cb.schedule_start_time, 
               cb.schedule_end_time, cb.schedule_days
        FROM conversations c
        LEFT JOIN chatbots cb ON c.chatbot_id = cb.id
        WHERE c.id = ? AND cb.is_active = 1
    ");
    $stmt->execute([$conversation_id]);
    $data = $stmt->fetch();
    
    if (!$data) {
        echo json_encode([
            'success' => true,
            'should_be_active' => false,
            'reason' => 'no_chatbot_assigned'
        ]);
        exit();
    }
    
    // Zamanlama aktif değilse, AI her zaman aktif
    if (!$data['schedule_enabled']) {
        // AI'yı aktif yap
        $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 1 WHERE id = ?");
        $stmt->execute([$conversation_id]);
        
        echo json_encode([
            'success' => true,
            'should_be_active' => true,
            'reason' => 'no_schedule'
        ]);
        exit();
    }
    
    // Zamanlama kontrolü
    date_default_timezone_set('Europe/Istanbul');
    $current_time = date('H:i:s');
    $current_day = date('w');
    
    // Gün kontrolü
    $is_active_day = true;
    if ($data['schedule_days']) {
        $active_days = explode(',', $data['schedule_days']);
        $is_active_day = in_array($current_day, $active_days);
    }
    
    // Saat kontrolü
    $start_time = $data['schedule_start_time'];
    $end_time = $data['schedule_end_time'];
    
    $is_within_time = false;
    if ($start_time && $end_time) {
        if ($start_time > $end_time) {
            // Gece geçişi
            $is_within_time = ($current_time >= $start_time || $current_time < $end_time);
        } else {
            // Normal aralık
            $is_within_time = ($current_time >= $start_time && $current_time < $end_time);
        }
    }
    
    $should_be_active = ($is_active_day && $is_within_time);
    
    // AI durumunu güncelle
    if ($should_be_active) {
        $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 1 WHERE id = ?");
        $stmt->execute([$conversation_id]);
    } else {
        $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 0 WHERE id = ?");
        $stmt->execute([$conversation_id]);
    }
    
    echo json_encode([
        'success' => true,
        'should_be_active' => $should_be_active,
        'reason' => $should_be_active ? 'within_schedule' : 'outside_schedule',
        'debug' => [
            'current_time' => $current_time,
            'current_day' => $current_day,
            'is_active_day' => $is_active_day,
            'is_within_time' => $is_within_time
        ]
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
