<?php
/**
 * Aktif Chatbot'u Getir API
 */

session_start();
require_once '../../config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

try {
    $stmt = $pdo->query("SELECT * FROM chatbots WHERE is_active = 1 LIMIT 1");
    $chatbot = $stmt->fetch();
    
    if ($chatbot) {
        echo json_encode([
            'success' => true,
            'chatbot' => $chatbot
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Aktif chatbot bulunamadı'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
