<?php
/**
 * Chatbot Aktif/Pasif Durumu Değiştirme API
 * Sadece 1 chatbot aynı anda aktif olabilir
 */

session_start();
require_once '../../config/database.php';
require_once '../../includes/functions.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Unauthorized']);
    exit();
}

$user = getUserById($_SESSION['user_id']);
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'error' => 'Forbidden']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id = $input['id'] ?? 0;
    $is_active = $input['is_active'] ?? false;
    
    if ($is_active) {
        // Aktif yapılıyorsa, önce tüm chatbot'ları pasif yap
        $pdo->exec("UPDATE chatbots SET is_active = 0");
        
        // Tüm sohbetlerdeki AI'yı pasif yap
        $pdo->exec("UPDATE conversations SET is_ai_active = 0");
        
        // Sonra seçili olanı aktif yap
        $stmt = $pdo->prepare("UPDATE chatbots SET is_active = 1, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$id]);
        
        // Bu chatbot'un zamanlama ayarlarını kontrol et
        $stmt = $pdo->prepare("SELECT schedule_enabled FROM chatbots WHERE id = ?");
        $stmt->execute([$id]);
        $chatbot = $stmt->fetch();
        
        if (!$chatbot['schedule_enabled']) {
            // Zamanlama KAPALI - Tüm sohbetlerdeki AI'yı AKTİF yap
            $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 1 WHERE chatbot_id = ?");
            $stmt->execute([$id]);
        } else {
            // Zamanlama AKTİF - Her sohbet için zamanlama kontrolü yap
            $stmt = $pdo->prepare("SELECT id FROM conversations WHERE chatbot_id = ?");
            $stmt->execute([$id]);
            $conversations = $stmt->fetchAll();
            
            foreach ($conversations as $conv) {
                if (function_exists('checkAndUpdateAISchedule')) {
                    checkAndUpdateAISchedule($conv['id']);
                }
            }
        }
    } else {
        // Pasif yapılıyorsa, sadece bu chatbot'u pasif yap
        $stmt = $pdo->prepare("UPDATE chatbots SET is_active = 0, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$id]);
        
        // Bu chatbot'a atanmış tüm sohbetlerdeki AI'yı pasif yap
        $stmt = $pdo->prepare("UPDATE conversations SET is_ai_active = 0 WHERE chatbot_id = ?");
        $stmt->execute([$id]);
    }
    
    echo json_encode([
        'success' => true,
        'refresh_required' => true,
        'message' => $is_active ? 'Chatbot aktif edildi' : 'Chatbot pasif edildi'
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
