<?php
/**
 * Sohbet Silme API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $conversationId = $input['conversation_id'] ?? null;
    
    if (!$conversationId) {
        throw new Exception('Sohbet ID gerekli');
    }
    
    // Sohbeti kontrol et
    $conversation = getConversationById($conversationId);
    if (!$conversation) {
        throw new Exception('Sohbet bulunamadı');
    }
    
    // Kullanıcının bu sohbeti silme yetkisi var mı?
    if ($conversation['assigned_to'] != $_SESSION['user_id']) {
        $user = getUserById($_SESSION['user_id']);
        if (!in_array($user['role'], ['admin', 'supervisor'])) {
            throw new Exception('Bu sohbeti silme yetkiniz yok');
        }
    }
    
    // Sohbeti sil (cascade delete ile tüm mesajlar da silinir)
    $stmt = $pdo->prepare("DELETE FROM conversations WHERE id = ?");
    $stmt->execute([$conversationId]);
    
    // Bildirimleri de sil
    $stmt = $pdo->prepare("DELETE FROM notifications WHERE conversation_id = ?");
    $stmt->execute([$conversationId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Sohbet başarıyla silindi'
    ]);
    
    writeLog("Sohbet silindi - ID: " . $conversationId . " - Kullanıcı: " . $_SESSION['user_id']);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
    
    writeLog("Sohbet silme hatası: " . $e->getMessage());
}
?>
