<?php
/**
 * Müşteri Silme API
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $customerId = $input['id'] ?? null;
    
    if (!$customerId) {
        throw new Exception('Müşteri ID gerekli');
    }
    
    // Müşteri var mı kontrol et
    $stmt = $pdo->prepare("SELECT id, name FROM customers WHERE id = ? AND status = 'active'");
    $stmt->execute([$customerId]);
    $customer = $stmt->fetch();
    
    if (!$customer) {
        throw new Exception('Müşteri bulunamadı');
    }
    
    // Kullanıcı yetki kontrolü (admin veya supervisor olmalı)
    $user = getUserById($_SESSION['user_id']);
    if (!in_array($user['role'], ['admin', 'supervisor'])) {
        throw new Exception('Müşteri silme yetkiniz yok');
    }
    
    // Müşteriye ait sohbetleri kontrol et
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM conversations WHERE customer_id = ?");
    $stmt->execute([$customerId]);
    $conversationCount = $stmt->fetch()['count'];
    
    if ($conversationCount > 0) {
        // Müşteriye ait sohbetleri sil (cascade delete ile mesajlar da silinir)
        $stmt = $pdo->prepare("DELETE FROM conversations WHERE customer_id = ?");
        $stmt->execute([$customerId]);
        
        // Bildirimleri de sil
        $stmt = $pdo->prepare("DELETE FROM notifications WHERE customer_id = ?");
        $stmt->execute([$customerId]);
    }
    
    // Müşteriyi sil
    $stmt = $pdo->prepare("DELETE FROM customers WHERE id = ?");
    $stmt->execute([$customerId]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Müşteri ve tüm sohbet geçmişi başarıyla silindi'
    ]);
    
    writeLog("Müşteri silindi - ID: " . $customerId . " - Ad: " . $customer['name'] . " - Kullanıcı: " . $_SESSION['user_id']);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
    
    writeLog("Müşteri silme hatası: " . $e->getMessage());
}
?>
