<?php
/**
 * Get Available Agents API
 * Returns list of agents available for assignment
 */

header('Content-Type: application/json');
session_start();

require_once '../config/database.php';
require_once '../includes/functions.php';
require_once '../includes/assignment-engine.php';

// Check authentication
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

$user_id = $_SESSION['user_id'];
$user = getUserById($user_id);

// Only admin and supervisor can view available agents
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Permission denied']);
    exit;
}

// Get query parameters
$platform = $_GET['platform'] ?? null;

try {
    $engine = getAssignmentEngine();
    $agents = $engine->getAvailableAgents($platform);
    
    echo json_encode([
        'success' => true,
        'count' => count($agents),
        'agents' => $agents
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
