<?php
/**
 * Bildirim Merkezi API
 * Gerçek zamanlı bildirimler için
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Kullanıcı giriş kontrolü
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    $user_id = $_SESSION['user_id'];
    $action = $_GET['action'] ?? 'get';
    
    switch ($action) {
        case 'get':
            // Bildirimleri getir
            $stmt = $pdo->prepare("
                SELECT n.*, c.id as conversation_id, cu.name as customer_name
                FROM notifications n
                LEFT JOIN conversations c ON n.conversation_id = c.id
                LEFT JOIN customers cu ON c.customer_id = cu.id
                WHERE n.user_id = ? AND n.is_read = 0
                ORDER BY n.created_at DESC
                LIMIT 50
            ");
            $stmt->execute([$user_id]);
            $notifications = $stmt->fetchAll();
            
            echo json_encode([
                'success' => true,
                'notifications' => $notifications
            ]);
            break;
            
        case 'mark_read':
            // Bildirimleri okundu olarak işaretle
            $notification_id = $_POST['notification_id'] ?? null;
            
            if ($notification_id) {
                $stmt = $pdo->prepare("UPDATE notifications SET is_read = 1, read_at = NOW() WHERE id = ? AND user_id = ?");
                $stmt->execute([$notification_id, $user_id]);
            } else {
                // Tüm bildirimleri okundu olarak işaretle
                $stmt = $pdo->prepare("UPDATE notifications SET is_read = 1, read_at = NOW() WHERE user_id = ?");
                $stmt->execute([$user_id]);
            }
            
            echo json_encode(['success' => true]);
            break;
            
        case 'create':
            // Yeni bildirim oluştur
            $conversation_id = $_POST['conversation_id'] ?? null;
            $type = $_POST['type'] ?? 'info';
            $title = $_POST['title'] ?? '';
            $message = $_POST['message'] ?? '';
            
            $stmt = $pdo->prepare("
                INSERT INTO notifications (user_id, conversation_id, type, title, message, created_at) 
                VALUES (?, ?, ?, ?, ?, NOW())
            ");
            $stmt->execute([$user_id, $conversation_id, $type, $title, $message]);
            
            echo json_encode(['success' => true]);
            break;
            
        default:
            throw new Exception('Geçersiz işlem');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
