// AI Durumu Periyodik Kontrol
// Her 10 saniyede bir AI durumunu kontrol et
setInterval(async function () {
    const multiCRM = window.multiCRM;
    if (!multiCRM || !multiCRM.currentConversationId) return;

    try {
        const response = await fetch('api/chatbots/check-schedule.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                conversation_id: multiCRM.currentConversationId
            })
        });

        const data = await response.json();
        const aiToggle = document.getElementById('ai-toggle');

        if (aiToggle && data.success) {
            // AI durumunu güncelle (sadece değişmişse)
            if (data.should_be_active && !aiToggle.checked) {
                aiToggle.checked = true;
                console.log('✅ AI otomatik aktif edildi');
            } else if (!data.should_be_active && aiToggle.checked) {
                aiToggle.checked = false;
                console.log('❌ AI otomatik pasif edildi');
            }
        }
    } catch (error) {
        console.error('AI durumu kontrol hatası:', error);
    }
}, 10000); // 10 saniye
