// Assignment dropdown functionality
let availableAgents = [];
let currentConversationData = null;

// Load available agents
async function loadAvailableAgents() {
    if (typeof window.userRole === 'undefined' || !['admin', 'supervisor'].includes(window.userRole)) {
        return;
    }

    try {
        const response = await fetch('api/get-available-agents.php');
        const result = await response.json();

        if (result.success) {
            availableAgents = result.agents;
            console.log('Available agents loaded:', availableAgents);
        }
    } catch (error) {
        console.error('Error loading agents:', error);
    }
}

// Update assignment dropdown
function updateAssignmentDropdown(conversation) {
    const dropdown = document.getElementById('assignment-dropdown');
    const select = document.getElementById('assign-to-agent');

    if (!dropdown || !select) return;

    // Store current conversation data
    currentConversationData = conversation;

    // Show dropdown
    dropdown.style.display = 'flex';

    // Populate dropdown
    select.innerHTML = '<option value="">Atanmamış</option>';

    availableAgents.forEach(agent => {
        const option = document.createElement('option');
        option.value = agent.id;
        option.textContent = `${agent.name} (${agent.current_conversations || 0}/${agent.max_conversations || 10})`;

        // Select current agent if assigned
        if (conversation.assigned_to && agent.id == conversation.assigned_to) {
            option.selected = true;
        }

        select.appendChild(option);
    });
}

// Handle assignment change
document.addEventListener('DOMContentLoaded', function () {
    const assignSelect = document.getElementById('assign-to-agent');

    if (assignSelect) {
        // Load agents on page load
        loadAvailableAgents();

        assignSelect.addEventListener('change', async function () {
            const agentId = this.value;
            const conversationId = window.app?.currentConversationId;

            if (!conversationId) {
                alert('Lütfen bir sohbet seçin');
                return;
            }

            try {
                let endpoint, body;

                if (agentId === '') {
                    // Unassign
                    alert('Atamayı kaldırma özelliği henüz eklenmedi');
                    return;
                } else if (currentConversationData && currentConversationData.assigned_to) {
                    // Transfer
                    endpoint = 'api/transfer-conversation.php';
                    body = {
                        conversation_id: conversationId,
                        to_agent_id: parseInt(agentId),
                        reason: 'Manuel transfer',
                        notes: 'Admin/Supervisor tarafından transfer edildi'
                    };
                } else {
                    // Assign
                    endpoint = 'api/assign-conversation.php';
                    body = {
                        conversation_id: conversationId,
                        agent_id: parseInt(agentId)
                    };
                }

                const response = await fetch(endpoint, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(body)
                });

                const result = await response.json();

                if (result.success) {
                    // Show success message
                    const agentName = availableAgents.find(a => a.id == agentId)?.name || 'Ajan';
                    alert(`Sohbet ${agentName} kullanıcısına atandı`);

                    // Reload conversations
                    if (window.app) {
                        window.app.loadConversations();
                    }

                    // Reload agents to update workload
                    await loadAvailableAgents();
                } else {
                    alert('Hata: ' + (result.message || 'Atama başarısız'));
                    // Revert selection
                    if (currentConversationData && currentConversationData.assigned_to) {
                        this.value = currentConversationData.assigned_to;
                    } else {
                        this.value = '';
                    }
                }
            } catch (error) {
                console.error('Assignment error:', error);
                alert('Bir hata oluştu');
            }
        });
    }
});

// Export for use in app.js
window.updateAssignmentDropdown = updateAssignmentDropdown;
window.loadAvailableAgents = loadAvailableAgents;
