<?php
session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';

// Kullanıcı kontrolü
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user = getUserById($_SESSION['user_id']);

// Sadece admin ve supervisor erişebilir
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    header('Location: index.php');
    exit();
}

// Chatbot'ları getir
$stmt = $pdo->query("
    SELECT c.*, u.name as creator_name,
           (SELECT COUNT(*) FROM chatbot_knowledge WHERE chatbot_id = c.id) as knowledge_count
    FROM chatbots c
    LEFT JOIN users u ON c.created_by = u.id
    ORDER BY c.created_at DESC
");
$chatbots = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chatbot AI - MultiCRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .chatbot-card {
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .chatbot-card:hover {
            border-color: #3b82f6;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.15);
            transform: translateY(-2px);
        }
        .chatbot-card.active {
            border-color: #3b82f6;
            background: #f0f9ff;
        }
        .chatbot-type-badge {
            padding: 4px 12px;
            border-radius: 6px;
            font-size: 12px;
            font-weight: 600;
        }
        .chatbot-type-badge.sales {
            background: #dcfce7;
            color: #166534;
        }
        .chatbot-type-badge.support {
            background: #dbeafe;
            color: #1e40af;
        }
        .chatbot-type-badge.info {
            background: #fef3c7;
            color: #92400e;
        }
        .chatbot-type-badge.custom {
            background: #f3e8ff;
            color: #6b21a8;
        }
        .knowledge-file {
            background: white;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .file-upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 12px;
            padding: 40px;
            text-align: center;
            background: #f8fafc;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .file-upload-area:hover {
            border-color: #3b82f6;
            background: #f0f9ff;
        }
        .file-upload-area.dragover {
            border-color: #3b82f6;
            background: #dbeafe;
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    
    <div class="main-content">
        <div class="container-fluid p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h2><i class="fas fa-robot text-primary"></i> Chatbot AI Yönetimi</h2>
                    <p class="text-muted">Yapay zeka destekli chatbot'larınızı oluşturun ve yönetin</p>
                </div>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createChatbotModal">
                    <i class="fas fa-plus"></i> Yeni Chatbot
                </button>
            </div>

            <div class="row">
                <!-- Sol Panel: Chatbot Listesi -->
                <div class="col-lg-4">
                    <div class="card shadow-sm">
                        <div class="card-header bg-white">
                            <h5 class="mb-0">Chatbot'larım (<?php echo count($chatbots); ?>)</h5>
                        </div>
                        <div class="card-body p-2" id="chatbot-list">
                            <?php foreach ($chatbots as $bot): ?>
                            <div class="chatbot-card" data-chatbot-id="<?php echo $bot['id']; ?>" onclick="selectChatbot(<?php echo $bot['id']; ?>)">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <h6 class="mb-0">
                                        <i class="fas fa-robot text-primary"></i>
                                        <?php echo htmlspecialchars($bot['name']); ?>
                                    </h6>
                                    <span class="chatbot-type-badge <?php echo $bot['type']; ?>">
                                        <?php 
                                        $types = ['sales' => 'Satış', 'support' => 'Destek', 'info' => 'Bilgi', 'custom' => 'Özel'];
                                        echo $types[$bot['type']];
                                        ?>
                                    </span>
                                </div>
                                <p class="text-muted small mb-2"><?php echo htmlspecialchars(substr($bot['description'], 0, 80)); ?>...</p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">
                                        <i class="fas fa-file"></i> <?php echo $bot['knowledge_count']; ?> dosya
                                    </small>
                                    <button class="btn btn-sm <?php echo $bot['is_active'] ? 'btn-success' : 'btn-outline-secondary'; ?>" 
                                            onclick="event.stopPropagation(); toggleChatbotStatus(<?php echo $bot['id']; ?>, <?php echo $bot['is_active'] ? 'false' : 'true'; ?>)">
                                        <i class="fas fa-<?php echo $bot['is_active'] ? 'check-circle' : 'circle'; ?>"></i>
                                        <?php echo $bot['is_active'] ? 'Aktif' : 'Pasif'; ?>
                                    </button>
                                </div>
                            </div>
                            <?php endforeach; ?>
                            
                            <?php if (empty($chatbots)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-robot fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Henüz chatbot oluşturmadınız</p>
                                <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#createChatbotModal">
                                    İlk Chatbot'u Oluştur
                                </button>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Sağ Panel: Chatbot Detayları -->
                <div class="col-lg-8">
                    <div class="card shadow-sm" id="chatbot-details" style="display: none;">
                        <div class="card-header bg-white d-flex justify-content-between align-items-center">
                            <h5 class="mb-0" id="chatbot-name">Chatbot Detayları</h5>
                            <div>
                                <button class="btn btn-sm btn-outline-primary" onclick="editChatbot()">
                                    <i class="fas fa-edit"></i> Düzenle
                                </button>
                                <button class="btn btn-sm btn-outline-danger" onclick="deleteChatbot()">
                                    <i class="fas fa-trash"></i> Sil
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Genel Bilgiler -->
                            <div class="mb-4">
                                <h6 class="text-muted mb-3">Genel Bilgiler</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label small text-muted">İsim</label>
                                        <p id="detail-name" class="fw-bold"></p>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label small text-muted">Tip</label>
                                        <p id="detail-type"></p>
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label class="form-label small text-muted">Açıklama</label>
                                        <p id="detail-description"></p>
                                    </div>
                                </div>
                            </div>

                            <!-- Sistem Prompt'u -->
                            <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="text-muted mb-0">Sistem Talimatı</h6>
                                    <button class="btn btn-sm btn-primary" onclick="saveSystemPrompt()" id="save-prompt-btn" style="display: none;">
                                        <i class="fas fa-save"></i> Kaydet
                                    </button>
                                </div>
                                <textarea class="form-control" id="detail-prompt" rows="8" style="font-family: monospace; font-size: 13px;"></textarea>
                                <small class="text-muted">Chatbot'un nasıl davranması gerektiğini buraya yazın</small>
                            </div>

                            <!-- Model Ayarları -->
                            <div class="mb-4">
                                <h6 class="text-muted mb-3">Model Ayarları</h6>
                                <div class="row">
                                    <div class="col-md-4">
                                        <label class="form-label small text-muted">Model</label>
                                        <p id="detail-model"></p>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label small text-muted">Temperature</label>
                                        <p id="detail-temperature"></p>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="form-label small text-muted">Max Tokens</label>
                                        <p id="detail-max-tokens"></p>
                                    </div>
                                </div>
                            </div>

                            <!-- AI Zamanlama -->
                            <div class="mb-4">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="text-muted mb-0">⏰ AI Otomatik Zamanlama</h6>
                                    <div class="d-flex align-items-center gap-2">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="schedule-enabled">
                                            <label class="form-check-label" for="schedule-enabled">Aktif</label>
                                        </div>
                                        <button class="btn btn-sm btn-primary" onclick="saveSchedule()">
                                            <i class="fas fa-save"></i> Kaydet
                                        </button>
                                    </div>
                                </div>
                                
                                <div id="schedule-settings" style="display: none;">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i> 
                                        Belirlediğiniz saatler arasında gelen mesajlara AI otomatik yanıt verir.
                                    </div>
                                    
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <label class="form-label">Başlangıç Saati</label>
                                            <input type="time" class="form-control" id="schedule-start-time">
                                            <small class="text-muted">AI aktif olacak başlangıç saati</small>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">Bitiş Saati</label>
                                            <input type="time" class="form-control" id="schedule-end-time">
                                            <small class="text-muted">AI pasif olacak bitiş saati</small>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="form-label">Aktif Günler</label>
                                        <div class="btn-group w-100" role="group">
                                            <input type="checkbox" class="btn-check" id="day-1" value="1">
                                            <label class="btn btn-outline-primary" for="day-1">Pzt</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-2" value="2">
                                            <label class="btn btn-outline-primary" for="day-2">Sal</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-3" value="3">
                                            <label class="btn btn-outline-primary" for="day-3">Çar</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-4" value="4">
                                            <label class="btn btn-outline-primary" for="day-4">Per</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-5" value="5">
                                            <label class="btn btn-outline-primary" for="day-5">Cum</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-6" value="6">
                                            <label class="btn btn-outline-primary" for="day-6">Cmt</label>
                                            
                                            <input type="checkbox" class="btn-check" id="day-0" value="0">
                                            <label class="btn btn-outline-primary" for="day-0">Paz</label>
                                        </div>
                                        <small class="text-muted">AI'nın aktif olacağı günleri seçin</small>
                                    </div>
                                </div>
                            </div>

                            <!-- Bilgi Bankası -->
                            <div class="mb-4">
                                <h6 class="text-muted mb-3">Bilgi Bankası</h6>
                                
                                <!-- Dosya Yükleme -->
                                <div class="file-upload-area mb-3" id="file-upload-area">
                                    <i class="fas fa-cloud-upload-alt fa-3x text-primary mb-3"></i>
                                    <p class="mb-2"><strong>Dosya Sürükle veya Tıkla</strong></p>
                                    <p class="text-muted small">PDF, TXT, DOCX (Maks. 10MB)</p>
                                    <input type="file" id="knowledge-file-input" accept=".pdf,.txt,.docx" style="display: none;" multiple>
                                </div>

                                <!-- Yüklü Dosyalar -->
                                <div id="knowledge-files-list"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Boş Durum -->
                    <div class="card shadow-sm" id="empty-state">
                        <div class="card-body text-center py-5">
                            <i class="fas fa-hand-pointer fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">Bir chatbot seçin</h5>
                            <p class="text-muted">Detayları görmek için sol taraftan bir chatbot seçin</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create Chatbot Modal -->
    <div class="modal fade" id="createChatbotModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Chatbot Oluştur</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form id="createChatbotForm">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">İsim *</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Tip *</label>
                            <select class="form-select" name="type" required>
                                <option value="sales">Satış</option>
                                <option value="support">Teknik Destek</option>
                                <option value="info">Bilgi</option>
                                <option value="custom">Özel</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Açıklama</label>
                            <textarea class="form-control" name="description" rows="2"></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sistem Talimatı *</label>
                            <textarea class="form-control" name="system_prompt" rows="6" required></textarea>
                            <small class="text-muted">Chatbot'un nasıl davranması gerektiğini buraya yazın</small>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Model</label>
                                <select class="form-select" name="model">
                                    <option value="gemini-2.0-flash">Gemini 2.0 Flash</option>
                                    <option value="gemini-1.5-flash">Gemini 1.5 Flash</option>
                                    <option value="gemini-1.5-pro">Gemini 1.5 Pro</option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Temperature</label>
                                <input type="number" class="form-control" name="temperature" value="0.7" min="0" max="1" step="0.1">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Max Tokens</label>
                                <input type="number" class="form-control" name="max_tokens" value="1000">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" class="btn btn-primary">Oluştur</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/chatbot-ai.js"></script>
</body>
</html>
