<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔍 CRM HATA KONTROLÜ\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// Test 1: Database bağlantısı
echo "1️⃣  DATABASE BAĞLANTISI:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    require_once 'config/database.php';
    echo "✅ Database bağlantısı başarılı\n";
    echo "   PDO: " . (isset($pdo) ? 'OK' : 'FAIL') . "\n\n";
} catch (Exception $e) {
    echo "❌ Database hatası: " . $e->getMessage() . "\n\n";
}

// Test 2: Functions dosyası
echo "2️⃣  FUNCTIONS DOSYASI:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    require_once 'includes/functions.php';
    echo "✅ Functions yüklendi\n\n";
} catch (Exception $e) {
    echo "❌ Functions hatası: " . $e->getMessage() . "\n\n";
}

// Test 3: Session
echo "3️⃣  SESSION:\n";
echo "───────────────────────────────────────────────────────────\n";
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
echo "Session Status: " . session_status() . "\n";
echo "Session ID: " . session_id() . "\n";
echo "User ID: " . ($_SESSION['user_id'] ?? 'Not set') . "\n\n";

// Test 4: Index.php syntax kontrolü
echo "4️⃣  INDEX.PHP SYNTAX:\n";
echo "───────────────────────────────────────────────────────────\n";
$output = shell_exec('php -l index.php 2>&1');
echo $output . "\n";

// Test 5: Son PHP hatalarını göster
echo "5️⃣  PHP ERROR LOG:\n";
echo "───────────────────────────────────────────────────────────\n";
$errorLog = ini_get('error_log');
if ($errorLog && file_exists($errorLog)) {
    $errors = file_get_contents($errorLog);
    $lines = explode("\n", $errors);
    $lastErrors = array_slice($lines, -20);
    echo implode("\n", $lastErrors) . "\n";
} else {
    echo "Error log bulunamadı: " . $errorLog . "\n";
}

echo "\n═══════════════════════════════════════════════════════════\n";
echo "📝 SONUÇ:\n";
echo "═══════════════════════════════════════════════════════════\n";
echo "Bu bilgileri bana gönderin!\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

