<?php
require_once 'config/database.php';

try {
    // Messages tablosu yapısını kontrol et
    $stmt = $pdo->query("DESCRIBE messages");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "=== MESSAGES TABLE STRUCTURE ===\n\n";
    foreach ($columns as $column) {
        echo sprintf("%-25s %-20s %s\n", 
            $column['Field'], 
            $column['Type'], 
            $column['Null'] === 'YES' ? 'NULL' : 'NOT NULL'
        );
    }
    
    echo "\n\n=== SAMPLE MESSAGES (Last 5) ===\n\n";
    $stmt = $pdo->query("SELECT * FROM messages ORDER BY created_at DESC LIMIT 5");
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($messages as $msg) {
        echo "ID: {$msg['id']}\n";
        echo "Conversation ID: {$msg['conversation_id']}\n";
        echo "Sender Type: {$msg['sender_type']}\n";
        echo "Content: " . substr($msg['content'], 0, 50) . "...\n";
        echo "Created: {$msg['created_at']}\n";
        echo str_repeat("-", 50) . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
