<?php
/**
 * Debug script - Mesaj gönderme ve görüntüleme testi
 */
session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';

// Kullanıcı kontrolü
if (!isset($_SESSION['user_id'])) {
    die("Lütfen önce giriş yapın: <a href='login.php'>Giriş</a>");
}

echo "<h2>Mesaj Debug Testi</h2>";
echo "<hr>";

// Son 5 mesajı göster
echo "<h3>Son 5 Mesaj (Veritabanı):</h3>";
try {
    $stmt = $pdo->query("
        SELECT m.*, c.customer_id, cu.name as customer_name 
        FROM messages m
        LEFT JOIN conversations c ON m.conversation_id = c.id
        LEFT JOIN customers cu ON c.customer_id = cu.id
        ORDER BY m.created_at DESC 
        LIMIT 5
    ");
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Conversation</th><th>Customer</th><th>Sender Type</th><th>Content</th><th>Created</th></tr>";
    foreach ($messages as $msg) {
        echo "<tr>";
        echo "<td>{$msg['id']}</td>";
        echo "<td>{$msg['conversation_id']}</td>";
        echo "<td>{$msg['customer_name']}</td>";
        echo "<td>{$msg['sender_type']}</td>";
        echo "<td>" . htmlspecialchars(substr($msg['content'], 0, 50)) . "...</td>";
        echo "<td>{$msg['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red'>Hata: " . $e->getMessage() . "</p>";
}

echo "<hr>";

// API Test
echo "<h3>API Test (get-messages.php):</h3>";
if (isset($_GET['test_conversation'])) {
    $convId = $_GET['test_conversation'];
    
    echo "<p>Conversation ID: $convId</p>";
    
    // API'yi çağır
    $url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/api/get-messages.php?conversation_id=$convId";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_COOKIE, session_name() . '=' . session_id());
    $response = curl_exec($ch);
    curl_close($ch);
    
    echo "<h4>API Response:</h4>";
    echo "<pre>" . htmlspecialchars($response) . "</pre>";
    
    $data = json_decode($response, true);
    if ($data && isset($data['messages'])) {
        echo "<p><strong>Mesaj Sayısı:</strong> " . count($data['messages']) . "</p>";
    }
}

echo "<hr>";

// Aktif sohbetleri listele
echo "<h3>Aktif Sohbetler:</h3>";
$conversations = getActiveConversations($_SESSION['user_id']);
echo "<ul>";
foreach ($conversations as $conv) {
    echo "<li>";
    echo "<a href='?test_conversation={$conv['id']}'>";
    echo "{$conv['customer_name']} (ID: {$conv['id']})";
    echo "</a>";
    echo " - Son mesaj: " . htmlspecialchars(substr($conv['last_message'] ?? 'Yok', 0, 30));
    echo "</li>";
}
echo "</ul>";

echo "<hr>";
echo "<p><a href='index.php'>Ana Sayfaya Dön</a></p>";
?>
