<?php
/**
 * Test AI Response Function
 */

require_once '../config/database.php';
require_once '../includes/functions.php';

// Test conversation ID - değiştirin
$test_conversation_id = 1; // Gerçek bir conversation ID girin
$test_message = "Merhaba, yardım edebilir misiniz?";
$test_platform = "whatsapp";

echo "<h2>AI Response Test</h2>";
echo "<p><strong>Conversation ID:</strong> $test_conversation_id</p>";
echo "<p><strong>Message:</strong> $test_message</p>";
echo "<p><strong>Platform:</strong> $test_platform</p>";

echo "<hr>";

// 1. Check Google AI Config
echo "<h3>1. Google AI Configuration</h3>";
if (isset($google_ai_config)) {
    echo "<pre>";
    echo "API Key: " . (empty($google_ai_config['api_key']) ? "❌ EMPTY" : "✅ SET (" . substr($google_ai_config['api_key'], 0, 20) . "...)") . "\n";
    echo "Model: " . ($google_ai_config['model'] ?? 'NOT SET') . "\n";
    echo "System Instruction: " . (empty($google_ai_config['system_instruction']) ? "❌ EMPTY" : "✅ SET") . "\n";
    echo "</pre>";
} else {
    echo "<p style='color: red;'>❌ Google AI Config NOT LOADED</p>";
}

echo "<hr>";

// 2. Check Conversation
echo "<h3>2. Conversation Status</h3>";
$stmt = $pdo->prepare("SELECT id, is_ai_active, customer_id, platform FROM conversations WHERE id = ?");
$stmt->execute([$test_conversation_id]);
$conv = $stmt->fetch();

if ($conv) {
    echo "<pre>";
    echo "ID: " . $conv['id'] . "\n";
    echo "AI Active: " . ($conv['is_ai_active'] ? "✅ YES" : "❌ NO") . "\n";
    echo "Customer ID: " . $conv['customer_id'] . "\n";
    echo "Platform: " . $conv['platform'] . "\n";
    echo "</pre>";
} else {
    echo "<p style='color: red;'>❌ Conversation NOT FOUND</p>";
}

echo "<hr>";

// 3. Test Google Gemini API
echo "<h3>3. Test Google Gemini API</h3>";

if (!empty($google_ai_config['api_key'])) {
    $model = $google_ai_config['model'] ?? 'gemini-pro';
    $url = "https://generativelanguage.googleapis.com/v1beta/models/{$model}:generateContent?key=" . $google_ai_config['api_key'];
    
    $data = [
        'contents' => [
            [
                'parts' => [
                    ['text' => "Merhaba, test mesajı"]
                ]
            ]
        ]
    ];
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "<p><strong>HTTP Code:</strong> $httpCode</p>";
    
    if ($httpCode === 200) {
        echo "<p style='color: green;'>✅ API Connection Successful</p>";
        $result = json_decode($response, true);
        $ai_reply = $result['candidates'][0]['content']['parts'][0]['text'] ?? 'No reply';
        echo "<p><strong>AI Reply:</strong> $ai_reply</p>";
    } else {
        echo "<p style='color: red;'>❌ API Error</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    }
} else {
    echo "<p style='color: red;'>❌ API Key not set</p>";
}

echo "<hr>";

// 4. Test processAIResponse function
echo "<h3>4. Test processAIResponse Function</h3>";

if (function_exists('processAIResponse')) {
    echo "<p>✅ Function exists</p>";
    
    if ($conv && $conv['is_ai_active']) {
        echo "<p>Calling processAIResponse...</p>";
        $result = processAIResponse($test_conversation_id, $test_message, $test_platform);
        echo "<p><strong>Result:</strong> " . ($result ? "✅ SUCCESS" : "❌ FAILED") . "</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ AI not active for this conversation or conversation not found</p>";
    }
} else {
    echo "<p style='color: red;'>❌ processAIResponse function NOT FOUND</p>";
}

?>
