<?php
require_once 'config/database.php';

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🗑️  TEST MÜŞTERİLERİNİ SİL\n";
echo "═══════════════════════════════════════════════════════════\n\n";

try {
    // Facebook müşterilerini bul
    $stmt = $pdo->query("
        SELECT * FROM customers 
        WHERE facebook_id IS NOT NULL 
        AND facebook_id != ''
    ");
    $customers = $stmt->fetchAll();
    
    echo "Silinecek müşteri sayısı: " . count($customers) . "\n\n";
    
    if (count($customers) === 0) {
        echo "✅ Silinecek müşteri yok!\n";
        exit;
    }
    
    foreach ($customers as $customer) {
        echo "─────────────────────────────────────────────────────────\n";
        echo "Müşteri ID: " . $customer['id'] . "\n";
        echo "İsim: " . $customer['name'] . "\n";
        echo "Facebook ID: " . $customer['facebook_id'] . "\n";
        
        // Müşteriyi sil (CASCADE ile sohbetler ve mesajlar da silinir)
        $deleteStmt = $pdo->prepare("DELETE FROM customers WHERE id = ?");
        $deleteStmt->execute([$customer['id']]);
        
        echo "✅ Silindi!\n\n";
    }
    
    echo "═══════════════════════════════════════════════════════════\n";
    echo "✅ Tüm test müşterileri silindi!\n";
    echo "\nŞimdi Messenger'dan YENİ mesaj gönderin!\n";
    echo "Gerçek isim-soyisim ile gelecek.\n";
    echo "═══════════════════════════════════════════════════════════\n";
    
} catch (PDOException $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}
?>

