<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔍 FİNAL KONTROL\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// Test 1: Database
echo "1️⃣  DATABASE:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    require_once 'config/database.php';
    echo "✅ Database OK\n\n";
} catch (Exception $e) {
    echo "❌ Database Error: " . $e->getMessage() . "\n\n";
    exit;
}

// Test 2: Functions
echo "2️⃣  FUNCTIONS:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    require_once 'includes/functions.php';
    echo "✅ Functions OK\n\n";
} catch (Exception $e) {
    echo "❌ Functions Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n\n";
    exit;
}

// Test 3: Test bir fonksiyon çağır
echo "3️⃣  FUNCTION TEST:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    if (function_exists('getUserById')) {
        echo "✅ getUserById() var\n";
    } else {
        echo "❌ getUserById() yok\n";
    }
    
    if (function_exists('getCustomerByFacebookId')) {
        echo "✅ getCustomerByFacebookId() var\n";
    } else {
        echo "❌ getCustomerByFacebookId() yok\n";
    }
    
    if (function_exists('createCustomer')) {
        echo "✅ createCustomer() var\n";
    } else {
        echo "❌ createCustomer() yok\n";
    }
    
    echo "\n";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n\n";
}

// Test 4: Session
echo "4️⃣  SESSION:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    echo "✅ Session başlatıldı\n";
    echo "Session ID: " . session_id() . "\n";
    echo "User ID: " . (isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 'Not logged in') . "\n\n";
} catch (Exception $e) {
    echo "❌ Session Error: " . $e->getMessage() . "\n\n";
}

// Test 5: Index.php'yi include et
echo "5️⃣  INDEX.PHP TEST:\n";
echo "───────────────────────────────────────────────────────────\n";
try {
    ob_start();
    include 'index.php';
    $output = ob_get_clean();
    
    if (strlen($output) > 0) {
        echo "✅ Index.php çalıştı\n";
        echo "Output uzunluğu: " . strlen($output) . " karakter\n";
        echo "İlk 200 karakter:\n";
        echo substr($output, 0, 200) . "...\n";
    } else {
        echo "❌ Index.php boş output döndü\n";
    }
} catch (Exception $e) {
    ob_get_clean();
    echo "❌ Index.php Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}

echo "\n═══════════════════════════════════════════════════════════\n";
echo "SONUÇ: Tüm çıktıyı bana gönderin!\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

