<?php
/**
 * Sidebar Component
 * Tüm sayfalarda kullanılacak tek sidebar
 */

// Aktif sayfa kontrolü
$current_page = basename($_SERVER['PHP_SELF']);
$active_inbox = ($current_page == 'index.php') ? 'active' : '';
$active_contacts = ($current_page == 'customers.php') ? 'active' : '';
$active_settings = ($current_page == 'settings.php') ? 'active' : '';
?>

<!-- Sidebar -->
<div class="col-md-3 sidebar">
    <!-- App Header -->
    <div class="app-header">
        <div class="app-logo">
            <div class="logo-icon">o</div>
            <span class="app-name">profaj</span>
        </div>
    </div>
    
    
    <!-- Navigation Menu -->
    <div class="sidebar-menu">
        <a href="index.php" class="menu-item <?php echo $active_inbox; ?>">
            <i class="far fa-comments"></i> Sohbetler
        </a>
        <a href="customers.php" class="menu-item <?php echo $active_contacts; ?>">
            <i class="fas fa-users"></i> Müşteriler
        </a>
        <?php if ($user['role'] === 'admin'): ?>
        <a href="users.php" class="menu-item <?php echo ($current_page == 'users.php') ? 'active' : ''; ?>">
            <i class="fas fa-user-shield"></i> Kullanıcılar
        </a>
        <?php endif; ?>
        <?php if (in_array($user['role'], ['admin', 'supervisor'])): ?>
        <a href="chatbot-ai.php" class="menu-item <?php echo ($current_page == 'chatbot-ai.php') ? 'active' : ''; ?>">
            <i class="fas fa-robot"></i> Chatbot AI
        </a>
        <?php endif; ?>
        <a href="settings.php" class="menu-item <?php echo $active_settings; ?>">
            <i class="fas fa-cogs"></i> Ayarlar
        </a>
    </div>
    
    <!-- User Profile -->
    <div class="user-profile">
        <div class="user-avatar">
            <div class="avatar-circle">
                <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
            </div>
            <div class="online-status"></div>
        </div>
        <div class="user-info">
            <div class="user-name"><?php echo htmlspecialchars($user['name']); ?></div>
            <div class="user-email"><?php echo htmlspecialchars($user['email']); ?></div>
        </div>
    </div>
</div>

