<?php
// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    session_start();
    require_once 'config/database.php';
    require_once 'includes/functions.php';

    // Eğer kullanıcı giriş yapmamışsa login sayfasına yönlendir
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit();
    }

    $user_id = $_SESSION['user_id'];
    $user = getUserById($user_id);
    
    if (!$user) {
        // Kullanıcı bulunamadı, session'ı temizle
        session_destroy();
        header('Location: login.php');
        exit();
    }
    
    $conversations = getActiveConversations($user_id);
    
} catch (Exception $e) {
    // Hata durumunda debug sayfasına yönlendir
    echo "<h1>Hata Oluştu</h1>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><a href='debug.php'>Hata Ayıklama</a></p>";
    echo "<p><a href='create-admin.php'>Admin Kullanıcısı Oluştur</a></p>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MultiCRM - WhatsApp CRM Sistemi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    
    <div class="main-content" style="display: flex; flex-direction: column; height: 100vh;">
        <div style="display: flex; flex: 1; overflow: hidden;">
            <!-- Conversations List -->
            <div class="conversations-panel">
                <div class="conversations-header">
                    <h5 style="margin: 0; padding: 0;">Sohbetler</h5>
                </div>
                
                <div class="conversations-list">
                    <?php if (empty($conversations)): ?>
                        <div class="no-conversations">
                            <i class="fas fa-comments"></i>
                            <p>Henüz sohbet yok</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($conversations as $conversation): ?>
                            <div class="conversation-item" data-conversation-id="<?php echo $conversation['id']; ?>">
                                <div class="conversation-avatar <?php echo $conversation['platform'] ?? 'whatsapp'; ?>">
                                    <i class="<?php echo ($conversation['platform'] === 'facebook') ? 'fab fa-facebook-messenger' : 'fab fa-whatsapp'; ?>"></i>
                                </div>
                                <div class="conversation-info">
                                    <div class="conversation-name"><?php echo htmlspecialchars($conversation['customer_name']); ?></div>
                                    <div class="conversation-preview"><?php echo htmlspecialchars(substr($conversation['last_message'] ?? '', 0, 50)); ?></div>
                                    <small style="color: #a0aec0;"><?php echo timeAgo($conversation['last_message_time']); ?></small>
                                </div>
                                <?php if ($conversation['unread_count'] > 0): ?>
                                    <span class="unread-badge"><?php echo $conversation['unread_count']; ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Chat Area -->
            <div class="chat-area">
                <div class="chat-header">
                    <div class="chat-customer-info">
                        <i class="fab fa-whatsapp" id="chat-platform-icon"></i>
                        <div>
                            <h5 id="chat-customer-name" style="margin: 0;">Sohbet Seçin</h5>
                            <small id="chat-customer-phone" style="margin: 0;">Bir sohbet seçerek mesajlaşmaya başlayın</small>
                        </div>
                    </div>
                    <div class="chat-actions">
                        <button class="btn btn-sm btn-outline-primary" id="customer-info-btn" style="display: none;">
                            <i class="fas fa-user"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-danger" id="delete-conversation-btn" title="Sohbeti Sil" style="display: none;">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>

                <div class="chat-messages" id="chat-messages">
                    <div class="no-chat-selected">
                        <i class="fas fa-comments"></i>
                        <p>Bir sohbet seçin</p>
                    </div>
                </div>

                <div class="chat-input-area" id="chat-input-area" style="display: none;">
                    <textarea class="message-input" id="message-input" placeholder="Mesajınızı yazın..." rows="3"></textarea>
                    <button class="btn btn-primary" id="send-message-btn">
                        <i class="fas fa-paper-plane"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Conversation Modal -->
    <div class="modal fade" id="deleteConversationModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Sohbeti Sil</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Bu sohbeti silmek istediğinizden emin misiniz?</p>
                    <p class="text-muted">Bu işlem geri alınamaz. Tüm mesajlar ve sohbet geçmişi silinecektir.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-danger" id="confirm-delete-conversation-btn">Sohbeti Sil</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/app.js"></script>
    <!-- realtime.js devre dışı bırakıldı - SSE ile çakışıyor (app.js SSE yapıyor) -->
    <!-- <script src="assets/js/realtime.js"></script> -->
</body>
</html>
