<?php
// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    session_start();
    require_once 'config/database.php';
    require_once 'includes/functions.php';

    // Eğer kullanıcı giriş yapmamışsa login sayfasına yönlendir
    if (!isset($_SESSION['user_id'])) {
        header('Location: login.php');
        exit();
    }

    $user_id = $_SESSION['user_id'];
    $user = getUserById($user_id);
    
    if (!$user) {
        // Kullanıcı bulunamadı, session'ı temizle
        session_destroy();
        header('Location: login.php');
        exit();
    }
    
    // Platform filtresi
    $platform_filter = $_GET['platform'] ?? 'all';
    
    // Kullanıcı rolüne göre sohbetleri getir
    if (in_array($user['role'], ['admin', 'supervisor'])) {
        // Admin ve supervisor tüm sohbetleri görebilir
        if ($platform_filter === 'all') {
            $conversations = getAllConversations(null, 'active', 100);
        } else {
            $conversations = getAllConversations($platform_filter, 'active', 100);
        }
        
        // Atanmamış sohbetleri getir
        $unassigned = getUnassignedConversations($platform_filter === 'all' ? null : $platform_filter, 20);
    } else {
        // Ajanlar sadece kendilerine atanmış sohbetleri görebilir
        if ($platform_filter === 'all') {
            $conversations = getActiveConversations($user_id);
        } else {
            $conversations = getConversationsByPlatform($user_id, $platform_filter, 'active');
        }
        $unassigned = [];
    }
    
} catch (Exception $e) {
    // Hata durumunda debug sayfasına yönlendir
    echo "<h1>Hata Oluştu</h1>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><a href='debug.php'>Hata Ayıklama</a></p>";
    echo "<p><a href='create-admin.php'>Admin Kullanıcısı Oluştur</a></p>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MultiCRM - Unified Inbox</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    
    <div class="main-content" style="display: flex; flex-direction: column; height: 100vh;">
        <div style="display: flex; flex: 1; overflow: hidden;">
            <!-- Conversations List -->
            <div class="conversations-panel">
                <div class="conversations-header">
                    <h5 style="margin: 0; padding: 0;">
                        <i class="fas fa-inbox"></i> Gelen Kutusu
                    </h5>
                </div>
                
                <!-- Platform Filters -->
                <div class="platform-filters">
                    <button class="platform-filter-btn <?php echo $platform_filter === 'all' ? 'active' : ''; ?>" 
                            onclick="filterByPlatform('all')">
                        <i class="fas fa-th"></i> Tümü
                    </button>
                    <button class="platform-filter-btn <?php echo $platform_filter === 'whatsapp' ? 'active' : ''; ?>" 
                            onclick="filterByPlatform('whatsapp')">
                        <i class="fab fa-whatsapp"></i> WhatsApp
                    </button>
                    <button class="platform-filter-btn <?php echo $platform_filter === 'facebook' ? 'active' : ''; ?>" 
                            onclick="filterByPlatform('facebook')">
                        <i class="fab fa-facebook-messenger"></i> Messenger
                    </button>
                    <button class="platform-filter-btn <?php echo $platform_filter === 'instagram' ? 'active' : ''; ?>" 
                            onclick="filterByPlatform('instagram')">
                        <i class="fab fa-instagram"></i> Instagram
                    </button>
                </div>
                
                <!-- Unassigned Conversations (Admin/Supervisor only) -->
                <?php if (!empty($unassigned)): ?>
                <div class="unassigned-section">
                    <span>
                        <i class="fas fa-exclamation-triangle"></i> Atanmamış Mesajlar
                    </span>
                    <span class="unassigned-count"><?php echo count($unassigned); ?></span>
                </div>
                <?php endif; ?>
                
                <div class="conversations-list">
                    <?php if (empty($conversations) && empty($unassigned)): ?>
                        <div class="no-conversations">
                            <i class="fas fa-comments"></i>
                            <p>Henüz sohbet yok</p>
                        </div>
                    <?php else: ?>
                        <!-- Unassigned Conversations -->
                        <?php foreach ($unassigned as $conversation): ?>
                            <div class="conversation-item unassigned" 
                                 data-conversation-id="<?php echo $conversation['id']; ?>"
                                 data-platform="<?php echo $conversation['platform'] ?? 'whatsapp'; ?>">
                                <div class="conversation-avatar <?php echo $conversation['platform'] ?? 'whatsapp'; ?>">
                                    <i class="<?php echo getPlatformIcon($conversation['platform'] ?? 'whatsapp'); ?>"></i>
                                </div>
                                <div class="conversation-info">
                                    <div class="conversation-name">
                                        <?php echo htmlspecialchars($conversation['customer_name']); ?>
                                        <span class="assignment-badge unassigned">Atanmamış</span>
                                    </div>
                                    <div class="conversation-preview">
                                        <?php echo htmlspecialchars(substr($conversation['last_message'] ?? 'Yeni sohbet', 0, 50)); ?>
                                    </div>
                                    <small style="color: #a0aec0;">
                                        <?php echo timeAgo($conversation['last_message_time'] ?? $conversation['created_at']); ?>
                                    </small>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                        <!-- Assigned Conversations -->
                        <?php foreach ($conversations as $conversation): ?>
                            <div class="conversation-item" 
                                 data-conversation-id="<?php echo $conversation['id']; ?>"
                                 data-platform="<?php echo $conversation['platform'] ?? 'whatsapp'; ?>">
                                <div class="conversation-avatar <?php echo $conversation['platform'] ?? 'whatsapp'; ?>">
                                    <i class="<?php echo getPlatformIcon($conversation['platform'] ?? 'whatsapp'); ?>"></i>
                                </div>
                                <div class="conversation-info">
                                    <div class="conversation-name">
                                        <?php echo htmlspecialchars($conversation['customer_name']); ?>
                                    </div>
                                    <div class="conversation-preview">
                                        <?php echo htmlspecialchars(substr($conversation['last_message'] ?? '', 0, 50)); ?>
                                    </div>
                                    <div style="display: flex; align-items: center; justify-content: space-between; margin-top: 4px;">
                                        <small style="color: #a0aec0;">
                                            <?php echo timeAgo($conversation['last_message_time']); ?>
                                        </small>
                                        <?php if (isset($conversation['agent_name']) && $user['role'] !== 'agent'): ?>
                                            <div class="agent-info">
                                                <div class="agent-avatar-small">
                                                    <?php echo mb_strtoupper(mb_substr($conversation['agent_name'], 0, 1, 'UTF-8'), 'UTF-8'); ?>
                                                </div>
                                                <span><?php echo htmlspecialchars($conversation['agent_name']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if ($conversation['unread_count'] > 0): ?>
                                    <span class="unread-badge"><?php echo $conversation['unread_count']; ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Chat Area -->
            <div class="chat-area">
                <div class="chat-header">
                    <div class="chat-customer-info">
                        <i class="fab fa-whatsapp" id="chat-platform-icon"></i>
                        <div>
                            <h5 id="chat-customer-name" style="margin: 0;">Sohbet Seçin</h5>
                            <small id="chat-customer-phone" style="margin: 0;">Bir sohbet seçerek mesajlaşmaya başlayın</small>
                        </div>
                    </div>
                    <div class="chat-actions">
                        <!-- AI Toggle -->
                        <div class="form-check form-switch" title="Yapay Zeka Asistanı">
                            <input class="form-check-input" type="checkbox" id="ai-toggle" disabled>
                            <label class="form-check-label" for="ai-toggle">
                                <i class="fas fa-robot text-primary"></i> AI
                            </label>
                        </div>

                        <!-- Customer Status Selector -->
                        <div class="customer-status-wrapper" id="customer-status-wrapper" style="display: none;">
                            <select id="customer-status-selector" class="form-select form-select-sm">
                                <option value="">Durum Seçin</option>
                                <option value="potential">🎯 Potansiyel Müşteri</option>
                                <option value="info_received">📋 Bilgi Alındı</option>
                                <option value="positive">✅ Olumlu</option>
                                <option value="negative">❌ Olumsuz</option>
                                <option value="pending">⏳ Beklemede</option>
                            </select>
                        </div>

                        <?php if (in_array($user['role'], ['admin', 'supervisor'])): ?>
                        <!-- Assignment Dropdown -->
                        <div class="assignment-wrapper" id="assignment-dropdown" style="display: none;">
                            <div class="assignment-icon">
                                <i class="fas fa-user-shield"></i>
                            </div>
                            <select id="assign-to-agent" class="form-select assignment-select">
                                <option value="">Yükleniyor...</option>
                            </select>
                            <div class="assignment-arrow">
                                <i class="fas fa-chevron-down"></i>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <button class="btn btn-sm btn-outline-primary" id="customer-info-btn" style="display: none;">
                            <i class="fas fa-user"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-danger" id="delete-conversation-btn" title="Sohbeti Sil" style="display: none;">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </div>

                <div class="chat-messages" id="chat-messages">
                    <div class="no-chat-selected">
                        <i class="fas fa-comments"></i>
                        <p>Bir sohbet seçin</p>
                    </div>
                </div>

                <div class="chat-input-area" id="chat-input-area" style="display: none;">
                    <textarea class="message-input" id="message-input" placeholder="Mesajınızı yazın..." rows="3"></textarea>
                    <button class="btn btn-primary" id="send-message-btn">
                        <i class="fas fa-paper-plane"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Conversation Modal -->
    <div class="modal fade" id="deleteConversationModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Sohbeti Sil</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Bu sohbeti silmek istediğinizden emin misiniz?</p>
                    <p class="text-muted">Bu işlem geri alınamaz. Tüm mesajlar ve sohbet geçmişi silinecektir.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-danger" id="confirm-delete-conversation-btn">Sohbeti Sil</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Assign Conversation Modal -->
    <?php if (in_array($user['role'], ['admin', 'supervisor'])): ?>
    <div class="modal fade" id="assignConversationModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Sohbeti Ata</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>Bu sohbeti hangi ajana atamak istersiniz?</p>
                    <div id="agent-list" class="agent-select-list">
                        <!-- Agents will be loaded here via JavaScript -->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="button" class="btn btn-primary" id="confirm-assign-btn">Ata</button>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/assignment.js"></script>
    <script src="assets/js/app.js"></script>
    <script>
        // Platform filter function
        function filterByPlatform(platform) {
            window.location.href = '?platform=' + platform;
        }
        
        // Store user role for JavaScript
        window.userRole = '<?php echo $user['role']; ?>';
    </script>
    <script src="assets/js/ai-status-checker.js"></script>
</body>
</html>
