<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📸 Instagram Kurulum Rehberi</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        h1 {
            background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-size: 42px;
            text-align: center;
            margin-bottom: 40px;
        }
        .step-container {
            margin: 30px 0;
        }
        .step {
            background: #f8f9fa;
            padding: 30px;
            margin: 20px 0;
            border-radius: 15px;
            border-left: 6px solid #dc2743;
        }
        .step-header {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        .step-number {
            background: linear-gradient(135deg, #f09433 0%,#dc2743 50%,#bc1888 100%);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 24px;
            margin-right: 20px;
        }
        .step-title {
            font-size: 24px;
            color: #333;
            font-weight: bold;
        }
        .step-content {
            margin-left: 70px;
            line-height: 1.8;
        }
        .code-box {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
            font-size: 14px;
        }
        .info-box {
            background: #d1ecf1;
            border-left: 5px solid #17a2b8;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .warning-box {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .success-box {
            background: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: linear-gradient(135deg, #f09433 0%,#dc2743 50%,#bc1888 100%);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: bold;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(220, 39, 67, 0.4);
        }
        .checklist {
            list-style: none;
            padding: 0;
        }
        .checklist li {
            padding: 12px;
            margin: 8px 0;
            background: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
        }
        .checklist li::before {
            content: "☐";
            font-size: 24px;
            margin-right: 15px;
            color: #dc2743;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fab fa-instagram"></i> Instagram Kurulum Rehberi</h1>

        <div class="info-box">
            <strong><i class="fas fa-info-circle"></i> Önemli Bilgi:</strong>
            <p style="margin-top: 10px;">
                Instagram Messaging, Facebook Graph API üzerinden çalışır. Instagram Business hesabınızın
                bir Facebook Page'e bağlı olması gerekir.
            </p>
        </div>

        <div class="step-container">
            <div class="step">
                <div class="step-header">
                    <div class="step-number">1</div>
                    <div class="step-title">Instagram Business Hesabı Oluştur</div>
                </div>
                <div class="step-content">
                    <p><strong>Instagram hesabınızı Business hesabına çevirin:</strong></p>
                    <ol style="margin-left: 20px; margin-top: 10px;">
                        <li>Instagram uygulamasını açın</li>
                        <li>Profil → Ayarlar → Hesap</li>
                        <li>"Profesyonel hesaba geç" seçeneğini seçin</li>
                        <li>"İşletme" kategorisini seçin</li>
                    </ol>
                    
                    <div class="warning-box" style="margin-top: 15px;">
                        <strong>⚠️ Dikkat:</strong> Kişisel hesaplar Instagram Messaging API kullanamaz.
                        Mutlaka Business veya Creator hesabı olmalı.
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">2</div>
                    <div class="step-title">Facebook Page'e Bağla</div>
                </div>
                <div class="step-content">
                    <p><strong>Instagram hesabınızı Facebook sayfanıza bağlayın:</strong></p>
                    <ol style="margin-left: 20px; margin-top: 10px;">
                        <li>Facebook'ta bir Business Page oluşturun (yoksa)</li>
                        <li>Instagram → Ayarlar → Hesap → Bağlı hesaplar</li>
                        <li>Facebook'u seçin ve sayfanızı bağlayın</li>
                    </ol>
                    
                    <div class="info-box" style="margin-top: 15px;">
                        <strong>💡 İpucu:</strong> Aynı Facebook Page'i hem Facebook Messenger hem de Instagram için kullanabilirsiniz.
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">3</div>
                    <div class="step-title">Facebook App'te Instagram Ürünü Ekle</div>
                </div>
                <div class="step-content">
                    <p><strong>Facebook Developers Console'da:</strong></p>
                    <ol style="margin-left: 20px; margin-top: 10px;">
                        <li><a href="https://developers.facebook.com/apps/" target="_blank" class="btn">Facebook Developers Console</a></li>
                        <li>App'inizi seçin</li>
                        <li>"Add Product" → "Instagram" seçin</li>
                        <li>"Set Up" butonuna tıklayın</li>
                    </ol>
                    
                    <div class="code-box" style="margin-top: 15px;">
<strong>Gerekli İzinler:</strong>
• instagram_basic
• instagram_manage_messages
• pages_messaging
• pages_read_engagement
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">4</div>
                    <div class="step-title">Instagram Account ID'yi Al</div>
                </div>
                <div class="step-content">
                    <p><strong>Graph API Explorer kullanarak:</strong></p>
                    <ol style="margin-left: 20px; margin-top: 10px;">
                        <li><a href="https://developers.facebook.com/tools/explorer/" target="_blank" class="btn">Graph API Explorer</a></li>
                        <li>Access Token'ı oluştur (User Token)</li>
                        <li>İzinleri seç: instagram_basic, pages_show_list</li>
                        <li>Query: <code>me/accounts</code></li>
                        <li>Facebook Page ID'nizi bulun</li>
                        <li>Query: <code>{page-id}?fields=instagram_business_account</code></li>
                        <li>Instagram Business Account ID'yi kopyalayın</li>
                    </ol>
                    
                    <div class="code-box" style="margin-top: 15px;">
<strong>Örnek Response:</strong>
{
  "instagram_business_account": {
    "id": "17841405309211844"  ← Bu ID'yi kullanacaksınız
  },
  "id": "123456789"
}
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">5</div>
                    <div class="step-title">Config Dosyasını Güncelle</div>
                </div>
                <div class="step-content">
                    <p><strong>config/instagram.php dosyasını düzenleyin:</strong></p>
                    
                    <div class="code-box">
$instagram_config = [
    'instagram_account_id' => '17841405309211844',  // Instagram Business Account ID
    'page_id' => '123456789',                       // Facebook Page ID
    'page_access_token' => 'EAAxxxxxxxxxxxxx',      // Page Access Token
    'verify_token' => 'instagram_webhook_verify',   // Özel token (değiştirin)
    'api_version' => 'v18.0'
];
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">6</div>
                    <div class="step-title">Webhook'u Ayarla</div>
                </div>
                <div class="step-content">
                    <p><strong>Facebook App → Instagram → Settings:</strong></p>
                    
                    <div class="code-box">
<strong>Webhook URL:</strong>
https://profaj.co/multicrm/api/webhook-instagram.php

<strong>Verify Token:</strong>
instagram_webhook_verify  (config/instagram.php'deki ile aynı olmalı)

<strong>Subscribe to:</strong>
☑ messages
☑ messaging_postbacks
☑ message_echoes
                    </div>
                    
                    <div class="warning-box" style="margin-top: 15px;">
                        <strong>⚠️ Önemli:</strong> Webhook URL'i test etmeden önce config dosyasını güncellediğinizden emin olun!
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">7</div>
                    <div class="step-title">Webhook'u Test Et</div>
                </div>
                <div class="step-content">
                    <p><strong>Test için:</strong></p>
                    <ol style="margin-left: 20px; margin-top: 10px;">
                        <li>Instagram hesabınıza DM gönderin (başka bir hesaptan)</li>
                        <li>CRM'de mesajın görünüp görünmediğini kontrol edin</li>
                        <li>CRM'den cevap gönderin</li>
                        <li>Instagram'da cevabın geldiğini kontrol edin</li>
                    </ol>
                    
                    <div class="success-box" style="margin-top: 15px;">
                        <strong>✅ Başarılı Test:</strong>
                        <ul style="margin-left: 20px; margin-top: 10px;">
                            <li>Mesaj CRM'de görünüyor</li>
                            <li>Kullanıcı adı doğru görünüyor</li>
                            <li>CRM'den gönderilen cevap Instagram'a ulaşıyor</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="step">
                <div class="step-header">
                    <div class="step-number">8</div>
                    <div class="step-title">App Review Başvurusu Yap</div>
                </div>
                <div class="step-content">
                    <p><strong>Canlı kullanım için App Review gerekli:</strong></p>
                    
                    <div class="info-box">
                        <strong>📋 Gerekli İzinler:</strong>
                        <ul style="margin-left: 20px; margin-top: 10px;">
                            <li><code>instagram_manage_messages</code> - Instagram mesajlarını yönetmek için</li>
                            <li><code>pages_messaging</code> - Mesaj gönderip almak için</li>
                        </ul>
                    </div>
                    
                    <p style="margin-top: 15px;"><strong>Başvuru için gerekli belgeler:</strong></p>
                    <ul style="margin-left: 20px;">
                        <li>CRM ekran görüntüleri</li>
                        <li>Demo video (Instagram DM yönetimini gösterin)</li>
                        <li>Privacy Policy</li>
                        <li>Terms of Service</li>
                    </ul>
                    
                    <a href="REKLAM_EKIBI_ICIN.php" class="btn" style="margin-top: 15px;">
                        📖 App Review Rehberi
                    </a>
                </div>
            </div>
        </div>

        <div class="success-box">
            <h3 style="margin-bottom: 15px;"><i class="fas fa-check-circle"></i> Kurulum Tamamlandı!</h3>
            <p>Instagram entegrasyonu hazır. App Review onaylandıktan sonra tüm Instagram DM'leri CRM'de görünecek.</p>
        </div>

        <div style="text-align: center; margin-top: 40px;">
            <a href="index.php" class="btn">
                <i class="fas fa-home"></i> Ana Sayfaya Dön
            </a>
            <a href="customers.php" class="btn" style="background: #6c757d;">
                <i class="fas fa-users"></i> Müşteriler
            </a>
        </div>
    </div>
</body>
</html>

