<?php
/**
 * MultiCRM - Basit Kurulum
 * Tek script ile tüm kurulum
 */

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MultiCRM - Kurulum</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }
        .setup-card { background: white; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); max-width: 800px; width: 100%; }
        .setup-header { background: linear-gradient(135deg, #25D366 0%, #128C7E 100%); color: white; padding: 2rem; text-align: center; }
        .setup-body { padding: 2rem; }
        .success-box { background: #d4edda; border: 1px solid #28a745; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
        .error-box { background: #f8d7da; border: 1px solid #dc3545; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
        .info-box { background: #e3f2fd; border: 1px solid #2196f3; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
    </style>
</head>
<body>
    <div class="container">
        <div class="setup-card">
            <div class="setup-header">
                <h2><i class="fab fa-whatsapp"></i> MultiCRM</h2>
                <p>Basit Kurulum</p>
            </div>
            <div class="setup-body">

<?php
// Veritabanı bağlantı bilgileri
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];

echo "<h3><i class='fas fa-database'></i> Veritabanı Bağlantısı</h3>";

try {
    // Veritabanına bağlan
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<div class='success-box'>";
    echo "<h5><i class='fas fa-check-circle'></i> Bağlantı Başarılı</h5>";
    echo "<p>Veritabanı: <strong>{$db_config['dbname']}</strong></p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='error-box'>";
    echo "<h5><i class='fas fa-times-circle'></i> Bağlantı Hatası</h5>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><strong>Çözüm:</strong> Veritabanı bilgilerini kontrol edin</p>";
    echo "</div>";
    exit();
}

echo "<h3><i class='fas fa-tools'></i> Tabloları Oluştur</h3>";

// Tabloları oluştur
$tables = [
    'users' => "CREATE TABLE IF NOT EXISTS `users` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `email` varchar(255) NOT NULL,
        `password` varchar(255) NOT NULL,
        `role` enum('admin','agent','supervisor') DEFAULT 'agent',
        `status` enum('active','inactive','suspended') DEFAULT 'active',
        `avatar` varchar(255) DEFAULT NULL,
        `phone` varchar(20) DEFAULT NULL,
        `timezone` varchar(50) DEFAULT 'Europe/Istanbul',
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `email` (`email`),
        KEY `status` (`status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'customers' => "CREATE TABLE IF NOT EXISTS `customers` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `phone` varchar(20) NOT NULL,
        `email` varchar(255) DEFAULT NULL,
        `avatar` varchar(255) DEFAULT NULL,
        `notes` text DEFAULT NULL,
        `tags` varchar(500) DEFAULT NULL,
        `status` enum('active','blocked','archived') DEFAULT 'active',
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `phone` (`phone`),
        KEY `email` (`email`),
        KEY `status` (`status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'agencies' => "CREATE TABLE IF NOT EXISTS `agencies` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `domain` varchar(255) DEFAULT NULL,
        `settings` json DEFAULT NULL,
        `status` enum('active','inactive','suspended') DEFAULT 'active',
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `domain` (`domain`),
        KEY `status` (`status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'conversations' => "CREATE TABLE IF NOT EXISTS `conversations` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `customer_id` int(11) NOT NULL,
        `assigned_to` int(11) NOT NULL,
        `status` enum('active','resolved','pending') DEFAULT 'active',
        `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
        `subject` varchar(255) DEFAULT NULL,
        `tags` varchar(500) DEFAULT NULL,
        `resolved_at` timestamp NULL DEFAULT NULL,
        `resolved_by` int(11) DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `customer_id` (`customer_id`),
        KEY `assigned_to` (`assigned_to`),
        KEY `status` (`status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'messages' => "CREATE TABLE IF NOT EXISTS `messages` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `conversation_id` int(11) NOT NULL,
        `content` text NOT NULL,
        `sender_type` enum('customer','agent','system') NOT NULL,
        `sender_id` int(11) DEFAULT NULL,
        `message_type` enum('text','image','document','audio','video','location','contact') DEFAULT 'text',
        `whatsapp_message_id` varchar(255) DEFAULT NULL,
        `is_read` tinyint(1) DEFAULT 0,
        `read_at` timestamp NULL DEFAULT NULL,
        `read_by` int(11) DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `conversation_id` (`conversation_id`),
        KEY `sender_type` (`sender_type`),
        KEY `whatsapp_message_id` (`whatsapp_message_id`),
        KEY `is_read` (`is_read`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'notifications' => "CREATE TABLE IF NOT EXISTS `notifications` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `user_id` int(11) NOT NULL,
        `conversation_id` int(11) DEFAULT NULL,
        `type` enum('info','success','warning','error','new_message','new_conversation') DEFAULT 'info',
        `title` varchar(255) NOT NULL,
        `message` text NOT NULL,
        `is_read` tinyint(1) DEFAULT 0,
        `read_at` timestamp NULL DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `user_id` (`user_id`),
        KEY `conversation_id` (`conversation_id`),
        KEY `is_read` (`is_read`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'user_agencies' => "CREATE TABLE IF NOT EXISTS `user_agencies` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `user_id` int(11) NOT NULL,
        `agency_id` int(11) NOT NULL,
        `role` enum('owner','admin','agent') DEFAULT 'agent',
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `user_agency` (`user_id`, `agency_id`),
        KEY `user_id` (`user_id`),
        KEY `agency_id` (`agency_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'settings' => "CREATE TABLE IF NOT EXISTS `settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `key` varchar(255) NOT NULL,
        `value` text DEFAULT NULL,
        `type` enum('string','number','boolean','json') DEFAULT 'string',
        `description` varchar(500) DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        UNIQUE KEY `key` (`key`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'webhook_logs' => "CREATE TABLE IF NOT EXISTS `webhook_logs` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `webhook_data` json NOT NULL,
        `processed` tinyint(1) DEFAULT 0,
        `error_message` text DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `processed` (`processed`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci",
    
    'message_attachments' => "CREATE TABLE IF NOT EXISTS `message_attachments` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `message_id` int(11) NOT NULL,
        `file_name` varchar(255) NOT NULL,
        `file_type` varchar(100) NOT NULL,
        `file_size` int(11) NOT NULL,
        `file_url` varchar(500) NOT NULL,
        `whatsapp_media_id` varchar(255) DEFAULT NULL,
        `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY (`id`),
        KEY `message_id` (`message_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
];

$successCount = 0;
$errorCount = 0;
$createdTables = [];

echo "<div class='info-box'>";
echo "<h5><i class='fas fa-info-circle'></i> Kurulum İşlemleri</h5>";
echo "<p>Tablolar oluşturuluyor...</p>";
echo "</div>";

foreach ($tables as $tableName => $sql) {
    try {
        $pdo->exec($sql);
        $successCount++;
        $createdTables[] = $tableName;
        echo "<p style='color: green;'>✓ Tablo oluşturuldu: $tableName</p>";
    } catch (PDOException $e) {
        $errorCount++;
        echo "<p style='color: red;'>✗ Hata ($tableName): " . $e->getMessage() . "</p>";
    }
}

echo "<h3><i class='fas fa-database'></i> Varsayılan Veriler</h3>";

try {
    // Admin kullanıcısını oluştur
    $hashedPassword = password_hash('password', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT IGNORE INTO users (name, email, password, role, status, created_at) VALUES (?, ?, ?, 'admin', 'active', NOW())");
    $stmt->execute(['Admin', 'admin@multicrm.com', $hashedPassword]);
    echo "<p style='color: green;'>✓ Admin kullanıcısı hazır</p>";
    
    // Varsayılan ajansı oluştur
    $stmt = $pdo->prepare("INSERT IGNORE INTO agencies (name, domain, status, created_at) VALUES (?, ?, 'active', NOW())");
    $stmt->execute(['MultiCRM', 'profaj.co']);
    echo "<p style='color: green;'>✓ Varsayılan ajans oluşturuldu</p>";
    
    // Admin kullanıcısını ajansa ata
    $stmt = $pdo->prepare("INSERT IGNORE INTO user_agencies (user_id, agency_id, role, created_at) VALUES (1, 1, 'owner', NOW())");
    $stmt->execute();
    echo "<p style='color: green;'>✓ Admin ajansa atandı</p>";
    
    // Varsayılan ayarları ekle
    $settings = [
        ['app_name', 'MultiCRM', 'string', 'Uygulama adı'],
        ['app_version', '1.0.0', 'string', 'Uygulama versiyonu'],
        ['timezone', 'Europe/Istanbul', 'string', 'Varsayılan saat dilimi'],
        ['whatsapp_webhook_verify_token', 'profaj_whatsapp_2024', 'string', 'WhatsApp webhook doğrulama tokenı'],
        ['whatsapp_phone_number_id', '592915763902531', 'string', 'WhatsApp telefon numarası ID'],
        ['whatsapp_business_account_id', '1368891014268764', 'string', 'WhatsApp işletme hesabı ID'],
        ['whatsapp_access_token', 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e', 'string', 'WhatsApp erişim tokenı'],
        ['whatsapp_api_version', 'v18.0', 'string', 'WhatsApp API versiyonu'],
        ['auto_assign_conversations', '1', 'boolean', 'Sohbetleri otomatik atama'],
        ['max_conversations_per_agent', '10', 'number', 'Ajan başına maksimum sohbet sayısı'],
        ['message_retention_days', '365', 'number', 'Mesaj saklama süresi (gün)']
    ];
    
    $settingsAdded = 0;
    foreach ($settings as $setting) {
        $stmt = $pdo->prepare("INSERT IGNORE INTO settings (`key`, value, type, description, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute($setting);
        if ($stmt->rowCount() > 0) {
            $settingsAdded++;
        }
    }
    
    echo "<p style='color: green;'>✓ $settingsAdded ayar eklendi</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Veri ekleme hatası: " . $e->getMessage() . "</p>";
}

echo "<h3><i class='fas fa-check-circle'></i> Kurulum Sonucu</h3>";

echo "<div class='success-box'>";
echo "<h5><i class='fas fa-check-circle'></i> Kurulum Başarılı!</h5>";
echo "<p><strong>Başarılı işlemler:</strong> $successCount</p>";
echo "<p><strong>Hatalar:</strong> $errorCount</p>";
if (!empty($createdTables)) {
    echo "<p><strong>Oluşturulan tablolar:</strong> " . implode(', ', $createdTables) . "</p>";
}
echo "</div>";

echo "<h3><i class='fas fa-rocket'></i> Kurulum Tamamlandı!</h3>";

echo "<div class='success-box'>";
echo "<h5><i class='fas fa-check-circle'></i> MultiCRM Hazır!</h5>";
echo "<p>Sistem kullanıma hazır. Giriş yapabilirsiniz.</p>";
echo "</div>";

echo "<h4>📋 Sonraki Adımlar:</h4>";
echo "<ol>";
echo "<li><strong>Giriş Yapın:</strong> <a href='login.php' target='_blank'>https://profaj.co/multicrm/login.php</a></li>";
echo "<li><strong>Varsayılan Giriş:</strong> admin@multicrm.com / password</li>";
echo "<li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ol>";

echo "<div class='alert alert-warning'>";
echo "<h6><i class='fas fa-shield-alt'></i> Güvenlik Uyarısı</h6>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra admin şifresini değiştirin!</p>";
echo "<p>Varsayılan şifre: <code>password</code></p>";
echo "</div>";

echo "<div class='d-flex justify-content-between mt-4'>";
echo "<a href='index.php' class='btn btn-primary'>";
echo "<i class='fas fa-home'></i> Ana Sayfaya Git";
echo "</a>";
echo "<a href='login.php' class='btn btn-success'>";
echo "<i class='fas fa-sign-in-alt'></i> Giriş Yap";
echo "</a>";
echo "</div>";

?>

            </div>
        </div>
    </div>
</body>
</html>
