<?php
/**
 * AI Zamanlama Sistemi - Veritabanı Kurulumu
 */

require_once '../config/database.php';

echo "<h2>AI Zamanlama - Veritabanı Güncellemesi</h2>";

try {
    // chatbots tablosuna zamanlama sütunları ekle
    echo "<h3>chatbots tablosuna zamanlama sütunları ekleniyor...</h3>";
    
    $columns = [
        'schedule_enabled' => "ALTER TABLE chatbots ADD COLUMN schedule_enabled TINYINT(1) DEFAULT 0 AFTER is_active",
        'schedule_start_time' => "ALTER TABLE chatbots ADD COLUMN schedule_start_time TIME DEFAULT NULL AFTER schedule_enabled",
        'schedule_end_time' => "ALTER TABLE chatbots ADD COLUMN schedule_end_time TIME DEFAULT NULL AFTER schedule_start_time",
        'schedule_days' => "ALTER TABLE chatbots ADD COLUMN schedule_days VARCHAR(20) DEFAULT NULL AFTER schedule_end_time",
        'schedule_timezone' => "ALTER TABLE chatbots ADD COLUMN schedule_timezone VARCHAR(50) DEFAULT 'Europe/Istanbul' AFTER schedule_days"
    ];
    
    foreach ($columns as $column => $sql) {
        $stmt = $pdo->query("SHOW COLUMNS FROM chatbots LIKE '$column'");
        if ($stmt->rowCount() == 0) {
            $pdo->exec($sql);
            echo "<p style='color: green;'>✅ $column sütunu eklendi</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ $column sütunu zaten mevcut</p>";
        }
    }
    
    echo "<hr>";
    echo "<h2 style='color: green;'>✅ Güncelleme Tamamlandı!</h2>";
    echo "<p>Chatbot AI sayfasında zamanlama ayarlarını yapabilirsiniz.</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
}
?>
