<?php
/**
 * MultiCRM - Otomatik Kurulum Scripti
 * Bu dosya tek tıkla kurulum yapar
 */

echo "<h2>MultiCRM - Otomatik Kurulum</h2>";
echo "<div style='background: #f8f9fa; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";

// Veritabanı bilgileri
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];

echo "<h3>1. Sistem Kontrolü</h3>";

// PHP versiyonu
$phpVersion = phpversion();
echo "<p><strong>PHP Versiyonu:</strong> $phpVersion ";
if (version_compare($phpVersion, '7.4.0', '>=')) {
    echo "<span style='color: green;'>✓</span>";
} else {
    echo "<span style='color: red;'>✗ (7.4+ gerekli)</span>";
}
echo "</p>";

// Gerekli uzantılar
$requiredExtensions = ['pdo', 'pdo_mysql', 'curl', 'json', 'mbstring'];
echo "<p><strong>PHP Uzantıları:</strong> ";
$allExtensionsOk = true;
foreach ($requiredExtensions as $ext) {
    if (extension_loaded($ext)) {
        echo "✓ $ext ";
    } else {
        echo "✗ $ext ";
        $allExtensionsOk = false;
    }
}
echo "</p>";

// SSL kontrolü
$sslActive = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
echo "<p><strong>SSL:</strong> " . ($sslActive ? "✓ HTTPS aktif" : "⚠ HTTP (WhatsApp webhook için HTTPS gerekli)") . "</p>";

// Yazma izinleri
$writable = is_writable('.');
echo "<p><strong>Dosya İzinleri:</strong> " . ($writable ? "✓ Yazma izni mevcut" : "✗ Yazma izni yok") . "</p>";

if (!$allExtensionsOk || !$writable) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24; margin: 1rem 0;'>";
    echo "<h4>❌ Kurulum Engellendi</h4>";
    echo "<p>Lütfen yukarıdaki hataları düzelttikten sonra tekrar deneyin.</p>";
    echo "</div>";
    exit();
}

echo "<h3>2. Veritabanı Kurulumu</h3>";

try {
    // Veritabanı bağlantısı
    $dsn = "mysql:host={$db_config['host']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<p>✓ Veritabanı bağlantısı başarılı</p>";
    
    // Veritabanını oluştur
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$db_config['dbname']}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<p>✓ Veritabanı oluşturuldu: {$db_config['dbname']}</p>";
    
    // Veritabanına bağlan
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    // SQL dosyasını oku ve çalıştır
    $sqlFile = __DIR__ . '/database.sql';
    if (!file_exists($sqlFile)) {
        throw new Exception("database.sql dosyası bulunamadı!");
    }
    
    $sql = file_get_contents($sqlFile);
    $statements = explode(';', $sql);
    
    $successCount = 0;
    $errorCount = 0;
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            try {
                $pdo->exec($statement);
                $successCount++;
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'already exists') === false) {
                    $errorCount++;
                }
            }
        }
    }
    
    echo "<p>✓ Tablolar oluşturuldu ($successCount başarılı, $errorCount uyarı)</p>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24; margin: 1rem 0;'>";
    echo "<h4>❌ Veritabanı Hatası</h4>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><strong>Çözüm:</strong> cPanel MySQL Database Wizard ile veritabanını oluşturun</p>";
    echo "</div>";
    exit();
}

echo "<h3>3. Dosya Yapılandırması</h3>";

// config/database.php dosyasını oluştur
$configContent = "<?php
// MultiCRM Veritabanı Yapılandırması
// Bu dosya otomatik oluşturulmuştur

\$db_config = [
    'host' => '{$db_config['host']}',
    'dbname' => '{$db_config['dbname']}',
    'username' => '{$db_config['username']}',
    'password' => '{$db_config['password']}',
    'charset' => 'utf8mb4'
];

// WhatsApp API ayarları
\$whatsapp_config = [
    'phone_number_id' => '592915763902531',
    'business_account_id' => '1368891014268764',
    'access_token' => 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e',
    'api_version' => 'v18.0',
    'verify_token' => 'profaj_whatsapp_2024',
    'webhook_url' => 'https://profaj.co/multicrm/api/webhook-whatsapp.php'
];

// PDO veritabanı bağlantısı
try {
    \$dsn = \"mysql:host={\$db_config['host']};dbname={\$db_config['dbname']};charset={\$db_config['charset']}\";
    \$pdo = new PDO(\$dsn, \$db_config['username'], \$db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
} catch (PDOException \$e) {
    die(\"Veritabanı bağlantı hatası: \" . \$e->getMessage());
}

// WhatsApp API fonksiyonları
function sendWhatsAppMessage(\$to, \$message, \$type = 'text') {
    global \$whatsapp_config;
    
    \$url = \"https://graph.facebook.com/{\$whatsapp_config['api_version']}/{\$whatsapp_config['phone_number_id']}/messages\";
    
    \$data = [
        'messaging_product' => 'whatsapp',
        'to' => \$to,
        'type' => \$type,
        'text' => ['body' => \$message]
    ];
    
    \$headers = [
        'Authorization: Bearer ' . \$whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    \$ch = curl_init();
    curl_setopt(\$ch, CURLOPT_URL, \$url);
    curl_setopt(\$ch, CURLOPT_POST, true);
    curl_setopt(\$ch, CURLOPT_POSTFIELDS, json_encode(\$data));
    curl_setopt(\$ch, CURLOPT_HTTPHEADER, \$headers);
    curl_setopt(\$ch, CURLOPT_RETURNTRANSFER, true);
    
    \$response = curl_exec(\$ch);
    \$httpCode = curl_getinfo(\$ch, CURLINFO_HTTP_CODE);
    curl_close(\$ch);
    
    return [
        'success' => \$httpCode === 200,
        'response' => json_decode(\$response, true),
        'http_code' => \$httpCode
    ];
}

function sendWhatsAppTemplate(\$to, \$template_name, \$language = 'tr', \$components = []) {
    global \$whatsapp_config;
    
    \$url = \"https://graph.facebook.com/{\$whatsapp_config['api_version']}/{\$whatsapp_config['phone_number_id']}/messages\";
    
    \$data = [
        'messaging_product' => 'whatsapp',
        'to' => \$to,
        'type' => 'template',
        'template' => [
            'name' => \$template_name,
            'language' => ['code' => \$language],
            'components' => \$components
        ]
    ];
    
    \$headers = [
        'Authorization: Bearer ' . \$whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    \$ch = curl_init();
    curl_setopt(\$ch, CURLOPT_URL, \$url);
    curl_setopt(\$ch, CURLOPT_POST, true);
    curl_setopt(\$ch, CURLOPT_POSTFIELDS, json_encode(\$data));
    curl_setopt(\$ch, CURLOPT_HTTPHEADER, \$headers);
    curl_setopt(\$ch, CURLOPT_RETURNTRANSFER, true);
    
    \$response = curl_exec(\$ch);
    \$httpCode = curl_getinfo(\$ch, CURLINFO_HTTP_CODE);
    curl_close(\$ch);
    
    return [
        'success' => \$httpCode === 200,
        'response' => json_decode(\$response, true),
        'http_code' => \$httpCode
    ];
}
?>";

file_put_contents('../config/database.php', $configContent);
echo "<p>✓ config/database.php dosyası oluşturuldu</p>";

// .htaccess dosyası oluştur
$htaccessContent = "# MultiCRM - Apache Yapılandırması

# PHP Ayarları
php_value upload_max_filesize 10M
php_value post_max_size 10M
php_value max_execution_time 300
php_value memory_limit 256M

# Güvenlik Ayarları
<Files \"*.sql\">
    Order Allow,Deny
    Deny from all
</Files>

<Files \"*.log\">
    Order Allow,Deny
    Deny from all
</Files>

# Log dizinini koru
<Directory \"logs\">
    Order Allow,Deny
    Deny from all
</Directory>

# Install dizinini koru
<Directory \"install\">
    Order Allow,Deny
    Deny from all
</Directory>

# URL Rewriting
RewriteEngine On

# HTTPS yönlendirmesi
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]

# Ana sayfa yönlendirmesi
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^$ index.php [L]

# Cache kontrolü
<IfModule mod_expires.c>
    ExpiresActive On
    ExpiresByType text/css \"access plus 1 month\"
    ExpiresByType application/javascript \"access plus 1 month\"
</IfModule>

# Gzip sıkıştırma
<IfModule mod_deflate.c>
    AddOutputFilterByType DEFLATE text/plain
    AddOutputFilterByType DEFLATE text/html
    AddOutputFilterByType DEFLATE text/css
    AddOutputFilterByType DEFLATE application/javascript
</IfModule>";

file_put_contents('../.htaccess', $htaccessContent);
echo "<p>✓ .htaccess dosyası oluşturuldu</p>";

// Install dizinini koru
file_put_contents('.htaccess', "Order Allow,Deny\nDeny from all");
echo "<p>✓ Install dizini güvenlik altına alındı</p>";

// Log dizini oluştur
if (!is_dir('../logs')) {
    mkdir('../logs', 0755, true);
}
echo "<p>✓ Log dizini oluşturuldu</p>";

echo "<h3>4. Kurulum Tamamlandı! 🎉</h3>";

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724; margin: 1rem 0;'>";
echo "<h4>✅ MultiCRM Başarıyla Kuruldu!</h4>";
echo "<p>Sistem cPanel'de çalışmaya hazır.</p>";
echo "</div>";

echo "<h4>📋 Sonraki Adımlar:</h4>";
echo "<ol>";
echo "<li><strong>Giriş Yapın:</strong> <a href='../login.php'>login.php</a></li>";
echo "<li><strong>Varsayılan Giriş:</strong> admin@multicrm.com / password</li>";
echo "<li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ol>";

echo "<h4>🔒 Güvenlik Uyarısı:</h4>";
echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; color: #856404;'>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra admin şifresini değiştirin!</p>";
echo "<p>Varsayılan şifre: <code>password</code></p>";
echo "</div>";

echo "<p><a href='../index.php' class='btn btn-primary'>Ana Sayfaya Git</a></p>";

echo "</div>";
?>
