<?php
/**
 * Database Structure Checker
 * Shows actual database structure to diagnose the issue
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config/database.php';

echo "<!DOCTYPE html>
<html lang='tr'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Database Structure Check</title>
    <style>
        body { font-family: monospace; max-width: 1200px; margin: 20px auto; padding: 20px; background: #f5f7fa; }
        .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        h1 { color: #1f93ff; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 8px; border: 1px solid #ddd; text-align: left; }
        th { background: #1f93ff; color: white; }
        .success { background: #dcfce7; color: #166534; padding: 12px; border-radius: 6px; margin: 10px 0; }
        .error { background: #fee2e2; color: #991b1b; padding: 12px; border-radius: 6px; margin: 10px 0; }
        .warning { background: #fef3c7; color: #92400e; padding: 12px; border-radius: 6px; margin: 10px 0; }
        .btn { background: #1f93ff; color: white; padding: 10px 20px; border: none; border-radius: 6px; cursor: pointer; font-size: 14px; font-weight: 600; text-decoration: none; display: inline-block; margin: 10px 5px; }
        .btn:hover { background: #0066cc; }
        .btn-danger { background: #dc2626; }
        .btn-danger:hover { background: #991b1b; }
    </style>
</head>
<body>
    <div class='container'>";

echo "<h1>🔍 Database Structure Check</h1>";

// Check customers table
echo "<h2>Customers Table Structure</h2>";
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM `customers`");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Check for required columns
    $columnNames = array_column($columns, 'Field');
    $requiredColumns = ['facebook_id', 'instagram_id', 'preferred_channel', 'last_seen_at'];
    
    echo "<h3>Required Columns Check:</h3>";
    foreach ($requiredColumns as $req) {
        if (in_array($req, $columnNames)) {
            echo "<div class='success'>✅ Column '$req' EXISTS</div>";
        } else {
            echo "<div class='error'>❌ Column '$req' MISSING</div>";
        }
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

// Check conversations table
echo "<h2>Conversations Table Structure</h2>";
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM `conversations`");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Check for required columns
    $columnNames = array_column($columns, 'Field');
    $requiredColumns = ['platform', 'assignment_type', 'assigned_at', 'first_response_time'];
    
    echo "<h3>Required Columns Check:</h3>";
    foreach ($requiredColumns as $req) {
        if (in_array($req, $columnNames)) {
            echo "<div class='success'>✅ Column '$req' EXISTS</div>";
        } else {
            echo "<div class='error'>❌ Column '$req' MISSING</div>";
        }
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

// Check all tables
echo "<h2>All Tables in Database</h2>";
try {
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<div class='info'>";
    echo "<strong>Tables found:</strong><br>";
    foreach ($tables as $table) {
        echo "• $table<br>";
    }
    echo "</div>";
    
    // Check for new tables
    $requiredTables = ['assignment_rules', 'user_permissions', 'activity_logs', 'conversation_transfers', 'agent_availability', 'agent_statistics'];
    
    echo "<h3>New Tables Check:</h3>";
    foreach ($requiredTables as $req) {
        if (in_array($req, $tables)) {
            echo "<div class='success'>✅ Table '$req' EXISTS</div>";
        } else {
            echo "<div class='error'>❌ Table '$req' MISSING</div>";
        }
    }
    
} catch (PDOException $e) {
    echo "<div class='error'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<hr>";
echo "<h2>Actions</h2>";
echo "<a href='fix-columns-simple.php' class='btn'>Try Simple Column Fix</a>";
echo "<a href='../index.php' class='btn'>Go to Dashboard</a>";

echo "</div></body></html>";
?>
