<?php
/**
 * MultiCRM - Temiz Kurulum (Düzeltilmiş SQL ile)
 * Foreign key sorunlarını çözen temiz kurulum
 */

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html>
<html lang='tr'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>MultiCRM - Temiz Kurulum</title>
    <link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>
    <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css' rel='stylesheet'>
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; }
        .setup-card { background: white; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); max-width: 900px; width: 100%; }
        .setup-header { background: linear-gradient(135deg, #25D366 0%, #128C7E 100%); color: white; padding: 2rem; text-align: center; }
        .setup-body { padding: 2rem; }
        .success-box { background: #d4edda; border: 1px solid #28a745; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
        .error-box { background: #f8d7da; border: 1px solid #dc3545; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
        .warning-box { background: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
        .info-box { background: #e3f2fd; border: 1px solid #2196f3; border-radius: 8px; padding: 1rem; margin: 1rem 0; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='setup-card'>
            <div class='setup-header'>
                <h2><i class='fab fa-whatsapp'></i> MultiCRM</h2>
                <p>Temiz Kurulum (Düzeltilmiş)</p>
            </div>
            <div class='setup-body'>";

// Veritabanı bağlantı bilgileri
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];

echo "<h3><i class='fas fa-database'></i> Veritabanı Bağlantısı</h3>";

try {
    // Veritabanına bağlan
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<div class='success-box'>";
    echo "<h5><i class='fas fa-check-circle'></i> Bağlantı Başarılı</h5>";
    echo "<p>Veritabanı: <strong>{$db_config['dbname']}</strong></p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='error-box'>";
    echo "<h5><i class='fas fa-times-circle'></i> Bağlantı Hatası</h5>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "</div>";
    exit();
}

echo "<h3><i class='fas fa-tools'></i> Temiz Kurulum Başlatılıyor</h3>";

// Düzeltilmiş SQL dosyasını kullan
$sqlFile = __DIR__ . '/database-fixed.sql';
if (!file_exists($sqlFile)) {
    echo "<div class='error-box'>";
    echo "<h5><i class='fas fa-times-circle'></i> SQL Dosyası Bulunamadı</h5>";
    echo "<p>database-fixed.sql dosyası bulunamadı!</p>";
    echo "</div>";
    exit();
}

$sql = file_get_contents($sqlFile);

echo "<div class='info-box'>";
echo "<h5><i class='fas fa-info-circle'></i> Kurulum Özellikleri</h5>";
echo "<ul class='mb-0'>";
echo "<li>Foreign key kısıtlamaları devre dışı bırakılır</li>";
echo "<li>Tablolar doğru sırada oluşturulur</li>";
echo "<li>Foreign key kısıtlamaları sonradan eklenir</li>";
echo "<li>Duplicate key hataları önlenir</li>";
echo "</ul>";
echo "</div>";

// SQL'i çalıştır
$statements = explode(';', $sql);
$successCount = 0;
$errorCount = 0;
$createdTables = [];
$addedData = [];

foreach ($statements as $statement) {
    $statement = trim($statement);
    if (!empty($statement)) {
        try {
            $pdo->exec($statement);
            $successCount++;
            
            // Tablo oluşturma
            if (stripos($statement, 'CREATE TABLE') !== false) {
                preg_match('/CREATE TABLE.*?`?(\w+)`?/i', $statement, $matches);
                $tableName = $matches[1] ?? 'Bilinmeyen';
                $createdTables[] = $tableName;
                echo "<p style='color: green;'>✓ Tablo oluşturuldu: $tableName</p>";
            }
            
            // Veri ekleme
            if (stripos($statement, 'INSERT') !== false) {
                preg_match('/INSERT.*?INTO.*?`?(\w+)`?/i', $statement, $matches);
                $tableName = $matches[1] ?? 'Bilinmeyen';
                $addedData[] = $tableName;
                echo "<p style='color: blue;'>✓ Veri eklendi: $tableName</p>";
            }
            
            // Foreign key ekleme
            if (stripos($statement, 'ALTER TABLE') !== false) {
                preg_match('/ALTER TABLE.*?`?(\w+)`?/i', $statement, $matches);
                $tableName = $matches[1] ?? 'Bilinmeyen';
                echo "<p style='color: purple;'>✓ Foreign key eklendi: $tableName</p>";
            }
            
        } catch (PDOException $e) {
            $errorCount++;
            echo "<p style='color: red;'>⚠ " . substr($e->getMessage(), 0, 100) . "...</p>";
        }
    }
}

echo "<h3><i class='fas fa-check-circle'></i> Kurulum Sonucu</h3>";

echo "<div class='success-box'>";
echo "<h5><i class='fas fa-check-circle'></i> Kurulum Başarılı!</h5>";
echo "<p><strong>Başarılı işlemler:</strong> $successCount</p>";
echo "<p><strong>Hatalar:</strong> $errorCount</p>";
echo "</div>";

if (!empty($createdTables)) {
    echo "<h5>📋 Oluşturulan Tablolar</h5>";
    echo "<div class='row'>";
    foreach ($createdTables as $table) {
        echo "<div class='col-md-6 mb-2'>";
        echo "<div class='card bg-light'>";
        echo "<div class='card-body p-2'>";
        echo "<i class='fas fa-check-circle text-success'></i> <strong>$table</strong>";
        echo "</div>";
        echo "</div>";
        echo "</div>";
    }
    echo "</div>";
}

if (!empty($addedData)) {
    echo "<h5>📊 Eklenen Veriler</h5>";
    echo "<div class='row'>";
    foreach ($addedData as $table) {
        echo "<div class='col-md-6 mb-2'>";
        echo "<div class='card bg-light'>";
        echo "<div class='card-body p-2'>";
        echo "<i class='fas fa-database text-primary'></i> <strong>$table</strong>";
        echo "</div>";
        echo "</div>";
        echo "</div>";
    }
    echo "</div>";
}

// Admin kullanıcısını kontrol et
echo "<h3><i class='fas fa-user'></i> Admin Kullanıcısı Kontrolü</h3>";

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM users WHERE email = 'admin@multicrm.com'");
    $stmt->execute();
    $adminExists = $stmt->fetch()['count'] > 0;
    
    if ($adminExists) {
        echo "<div class='success-box'>";
        echo "<h5><i class='fas fa-check-circle'></i> Admin Kullanıcısı Mevcut</h5>";
        echo "<p><strong>Email:</strong> admin@multicrm.com</p>";
        echo "<p><strong>Şifre:</strong> password</p>";
        echo "</div>";
    } else {
        echo "<div class='warning-box'>";
        echo "<h5><i class='fas fa-exclamation-triangle'></i> Admin Kullanıcısı Bulunamadı</h5>";
        echo "<p>Varsayılan admin kullanıcısı oluşturulamadı</p>";
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<div class='error-box'>";
    echo "<h5><i class='fas fa-times-circle'></i> Kullanıcı Kontrolü Hatası</h5>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "</div>";
}

echo "<h3><i class='fas fa-rocket'></i> Kurulum Tamamlandı!</h3>";

echo "<div class='success-box'>";
echo "<h5><i class='fas fa-check-circle'></i> MultiCRM Hazır!</h5>";
echo "<p>Sistem kullanıma hazır. Giriş yapabilirsiniz.</p>";
echo "</div>";

echo "<h4>📋 Sonraki Adımlar:</h4>";
echo "<ol>";
echo "<li><strong>Giriş Yapın:</strong> <a href='../login.php' target='_blank'>https://profaj.co/multicrm/login.php</a></li>";
echo "<li><strong>Varsayılan Giriş:</strong> admin@multicrm.com / password</li>";
echo "<li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ol>";

echo "<div class='warning-box'>";
echo "<h6><i class='fas fa-shield-alt'></i> Güvenlik Uyarısı</h6>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra admin şifresini değiştirin!</p>";
echo "<p>Varsayılan şifre: <code>password</code></p>";
echo "</div>";

echo "<div class='d-flex justify-content-between mt-4'>";
echo "<a href='../index.php' class='btn btn-primary'>";
echo "<i class='fas fa-home'></i> Ana Sayfaya Git";
echo "</a>";
echo "<a href='../login.php' class='btn btn-success'>";
echo "<i class='fas fa-sign-in-alt'></i> Giriş Yap";
echo "</a>";
echo "</div>";

echo "            </div>
        </div>
    </div>
</body>
</html>";
?>
