<?php
/**
 * MultiCRM - cPanel Uyumluluk Kontrolü
 * Bu dosya cPanel'de çalışabilirlik kontrolü yapar
 */

echo "<h2>MultiCRM - cPanel Uyumluluk Kontrolü</h2>";
echo "<div style='background: #f8f9fa; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";

// PHP versiyonu
$phpVersion = phpversion();
echo "<h3>1. PHP Versiyonu</h3>";
echo "<p><strong>Mevcut:</strong> PHP " . $phpVersion;
if (version_compare($phpVersion, '7.4.0', '>=')) {
    echo " <span style='color: green; font-weight: bold;'>✓ UYGUN</span>";
} else {
    echo " <span style='color: red; font-weight: bold;'>✗ UYGUN DEĞİL (7.4+ gerekli)</span>";
}
echo "</p>";

// Gerekli PHP uzantıları
echo "<h3>2. PHP Uzantıları</h3>";
$requiredExtensions = [
    'pdo' => 'Veritabanı bağlantısı',
    'pdo_mysql' => 'MySQL desteği',
    'curl' => 'WhatsApp API',
    'json' => 'API işlemleri',
    'mbstring' => 'Türkçe karakter desteği',
    'openssl' => 'HTTPS bağlantıları',
    'session' => 'Kullanıcı oturumu'
];

$allExtensionsOk = true;
foreach ($requiredExtensions as $ext => $description) {
    if (extension_loaded($ext)) {
        echo "<p style='color: green;'>✓ $ext - $description</p>";
    } else {
        echo "<p style='color: red;'>✗ $ext - $description (GEREKLİ)</p>";
        $allExtensionsOk = false;
    }
}

// Yazma izinleri
echo "<h3>3. Dosya İzinleri</h3>";
$writableDirs = [
    'logs' => 'Log dosyaları',
    'assets' => 'CSS/JS dosyaları',
    'install' => 'Kurulum dosyaları'
];

foreach ($writableDirs as $dir => $description) {
    if (is_dir($dir)) {
        if (is_writable($dir)) {
            echo "<p style='color: green;'>✓ $dir dizini yazılabilir - $description</p>";
        } else {
            echo "<p style='color: red;'>✗ $dir dizini yazılamıyor - $description</p>";
        }
    } else {
        echo "<p style='color: orange;'>⚠ $dir dizini bulunamadı - $description</p>";
    }
}

// SSL kontrolü
echo "<h3>4. SSL Sertifikası</h3>";
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    echo "<p style='color: green;'>✓ HTTPS aktif - WhatsApp webhook için gerekli</p>";
} else {
    echo "<p style='color: orange;'>⚠ HTTP (WhatsApp webhook için HTTPS gerekli)</p>";
}

// cURL testi
echo "<h3>5. cURL Testi</h3>";
if (function_exists('curl_init')) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($httpCode > 0 && empty($error)) {
        echo "<p style='color: green;'>✓ cURL çalışıyor - WhatsApp API bağlantısı mümkün</p>";
    } else {
        echo "<p style='color: red;'>✗ cURL hatası: " . $error . "</p>";
    }
} else {
    echo "<p style='color: red;'>✗ cURL yüklü değil</p>";
}

// Veritabanı bağlantı testi
echo "<h3>6. Veritabanı Bağlantısı</h3>";
try {
    $dsn = "mysql:host=localhost;charset=utf8mb4";
    $pdo = new PDO($dsn, 'profajco_multicrm', 'multi@@2025');
    echo "<p style='color: green;'>✓ Veritabanı bağlantısı başarılı</p>";
} catch (PDOException $e) {
    echo "<p style='color: red;'>✗ Veritabanı bağlantı hatası: " . $e->getMessage() . "</p>";
    echo "<p><strong>Çözüm:</strong> cPanel MySQL Database Wizard ile veritabanı oluşturun</p>";
}

// PHP ayarları
echo "<h3>7. PHP Ayarları</h3>";
$phpSettings = [
    'upload_max_filesize' => 'Dosya yükleme limiti',
    'post_max_size' => 'POST veri limiti',
    'max_execution_time' => 'Script çalışma süresi',
    'memory_limit' => 'Bellek limiti',
    'max_input_vars' => 'Maksimum input değişkeni'
];

foreach ($phpSettings as $setting => $description) {
    $value = ini_get($setting);
    echo "<p><strong>$description:</strong> $value</p>";
}

// cPanel özel kontroller
echo "<h3>8. cPanel Özel Kontroller</h3>";

// .htaccess desteği
if (function_exists('apache_get_modules')) {
    $modules = apache_get_modules();
    if (in_array('mod_rewrite', $modules)) {
        echo "<p style='color: green;'>✓ mod_rewrite aktif - URL rewriting mümkün</p>";
    } else {
        echo "<p style='color: orange;'>⚠ mod_rewrite pasif - URL rewriting sınırlı</p>";
    }
} else {
    echo "<p style='color: blue;'>ℹ Apache modül bilgisi alınamadı</p>";
}

// Disk alanı
$diskFree = disk_free_space('.');
$diskTotal = disk_total_space('.');
$diskUsed = $diskTotal - $diskFree;
$diskPercent = round(($diskUsed / $diskTotal) * 100, 2);

echo "<p><strong>Disk Kullanımı:</strong> " . $diskPercent . "% (" . 
     round($diskUsed / 1024 / 1024, 2) . " MB / " . 
     round($diskTotal / 1024 / 1024, 2) . " MB)</p>";

if ($diskPercent < 80) {
    echo "<p style='color: green;'>✓ Yeterli disk alanı mevcut</p>";
} else {
    echo "<p style='color: orange;'>⚠ Disk alanı sınırlı</p>";
}

echo "</div>";

// Sonuç
echo "<h3>🎯 Sonuç</h3>";
if ($allExtensionsOk && isset($_SERVER['HTTPS'])) {
    echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724;'>";
    echo "<h4>✅ MultiCRM cPanel'de Çalışabilir!</h4>";
    echo "<p>Sistem gereksinimleri karşılanıyor. Kuruluma devam edebilirsiniz.</p>";
    echo "<p><a href='install.php' class='btn btn-primary'>Kuruluma Başla</a></p>";
    echo "</div>";
} else {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24;'>";
    echo "<h4>⚠️ Bazı Gereksinimler Eksik</h4>";
    echo "<p>Yukarıdaki hataları düzelttikten sonra tekrar kontrol edin.</p>";
    echo "<p><strong>Önemli:</strong> WhatsApp webhook için HTTPS gereklidir!</p>";
    echo "</div>";
}

echo "<hr>";
echo "<h4>📋 cPanel Kurulum Adımları:</h4>";
echo "<ol>";
echo "<li><strong>SSL Sertifikası:</strong> cPanel SSL/TLS → Let's Encrypt</li>";
echo "<li><strong>Veritabanı:</strong> cPanel MySQL Database Wizard</li>";
echo "<li><strong>Dosyalar:</strong> cPanel File Manager ile yükle</li>";
echo "<li><strong>Kurulum:</strong> install.php çalıştır</li>";
echo "<li><strong>Webhook:</strong> WhatsApp Developer Console ayarla</li>";
echo "</ol>";

echo "<p><strong>Destek:</strong> Herhangi bir sorun için <a href='../README.md'>README.md</a> dosyasını inceleyin.</p>";
?>
