<?php
require_once '../config/database.php';

header('Content-Type: application/json');

$checks = [];
$needsUpdate = false;

try {
    // 1. Messages tablosu - content sütunu kontrolü
    $stmt = $pdo->query("DESCRIBE messages");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (in_array('content', $columns)) {
        $checks[] = [
            'title' => 'Messages Tablosu - content sütunu',
            'message' => 'content sütunu mevcut',
            'status' => 'success'
        ];
    } else {
        $checks[] = [
            'title' => 'Messages Tablosu - content sütunu',
            'message' => 'content sütunu eksik (message sütunundan dönüştürülecek)',
            'status' => 'pending'
        ];
        $needsUpdate = true;
    }
    
    // 2. Messages tablosu - sender_type sütunu kontrolü
    if (in_array('sender_type', $columns)) {
        $checks[] = [
            'title' => 'Messages Tablosu - sender_type sütunu',
            'message' => 'sender_type sütunu mevcut',
            'status' => 'success'
        ];
    } else {
        $checks[] = [
            'title' => 'Messages Tablosu - sender_type sütunu',
            'message' => 'sender_type sütunu eksik (eklenecek)',
            'status' => 'pending'
        ];
        $needsUpdate = true;
    }
    
    // 3. Conversations tablosu - platform sütunu kontrolü
    $stmt = $pdo->query("DESCRIBE conversations");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (in_array('platform', $columns)) {
        $checks[] = [
            'title' => 'Conversations Tablosu - platform sütunu',
            'message' => 'platform sütunu mevcut',
            'status' => 'success'
        ];
    } else {
        $checks[] = [
            'title' => 'Conversations Tablosu - platform sütunu',
            'message' => 'platform sütunu eksik (eklenecek)',
            'status' => 'pending'
        ];
        $needsUpdate = true;
    }
    
    // 4. Customers tablosu - facebook_id sütunu kontrolü
    $stmt = $pdo->query("DESCRIBE customers");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    if (in_array('facebook_id', $columns)) {
        $checks[] = [
            'title' => 'Customers Tablosu - facebook_id sütunu',
            'message' => 'facebook_id sütunu mevcut',
            'status' => 'success'
        ];
    } else {
        $checks[] = [
            'title' => 'Customers Tablosu - facebook_id sütunu',
            'message' => 'facebook_id sütunu eksik (eklenecek)',
            'status' => 'pending'
        ];
        $needsUpdate = true;
    }
    
    // 5. Activity_logs tablosu kontrolü
    $stmt = $pdo->query("SHOW TABLES LIKE 'activity_logs'");
    if ($stmt->rowCount() > 0) {
        $checks[] = [
            'title' => 'Activity Logs Tablosu',
            'message' => 'activity_logs tablosu mevcut',
            'status' => 'success'
        ];
    } else {
        $checks[] = [
            'title' => 'Activity Logs Tablosu',
            'message' => 'activity_logs tablosu eksik (oluşturulacak)',
            'status' => 'pending'
        ];
        $needsUpdate = true;
    }
    
    echo json_encode([
        'success' => true,
        'checks' => $checks,
        'needs_update' => $needsUpdate
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
