-- MultiCRM Veritabanı Kurulum Scripti (Düzeltilmiş)
-- Veritabanı: profajco_multicrm

-- Önce tüm foreign key kısıtlamalarını devre dışı bırak
SET FOREIGN_KEY_CHECKS = 0;

-- Kullanıcılar tablosu (ilk oluşturulmalı)
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL UNIQUE,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','agent','supervisor') DEFAULT 'agent',
  `status` enum('active','inactive','suspended') DEFAULT 'active',
  `avatar` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `timezone` varchar(50) DEFAULT 'Europe/Istanbul',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Müşteriler tablosu
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `tags` varchar(500) DEFAULT NULL,
  `status` enum('active','blocked','archived') DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `phone` (`phone`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ajanslar tablosu
CREATE TABLE IF NOT EXISTS `agencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `status` enum('active','inactive','suspended') DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sohbetler tablosu
CREATE TABLE IF NOT EXISTS `conversations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `assigned_to` int(11) NOT NULL,
  `status` enum('active','resolved','pending') DEFAULT 'active',
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `subject` varchar(255) DEFAULT NULL,
  `tags` varchar(500) DEFAULT NULL,
  `resolved_at` timestamp NULL DEFAULT NULL,
  `resolved_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `assigned_to` (`assigned_to`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Mesajlar tablosu
CREATE TABLE IF NOT EXISTS `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conversation_id` int(11) NOT NULL,
  `content` text NOT NULL,
  `sender_type` enum('customer','agent','system') NOT NULL,
  `sender_id` int(11) DEFAULT NULL,
  `message_type` enum('text','image','document','audio','video','location','contact') DEFAULT 'text',
  `whatsapp_message_id` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `read_at` timestamp NULL DEFAULT NULL,
  `read_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conversation_id` (`conversation_id`),
  KEY `sender_type` (`sender_type`),
  KEY `whatsapp_message_id` (`whatsapp_message_id`),
  KEY `is_read` (`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Mesaj ekleri tablosu
CREATE TABLE IF NOT EXISTS `message_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` int(11) NOT NULL,
  `file_url` varchar(500) NOT NULL,
  `whatsapp_media_id` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `message_id` (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Kullanıcı-ajans ilişkisi
CREATE TABLE IF NOT EXISTS `user_agencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `agency_id` int(11) NOT NULL,
  `role` enum('owner','admin','agent') DEFAULT 'agent',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_agency` (`user_id`, `agency_id`),
  KEY `user_id` (`user_id`),
  KEY `agency_id` (`agency_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- WhatsApp webhook logları
CREATE TABLE IF NOT EXISTS `webhook_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `webhook_data` json NOT NULL,
  `processed` tinyint(1) DEFAULT 0,
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `processed` (`processed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Bildirimler tablosu
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `conversation_id` int(11) DEFAULT NULL,
  `type` enum('info','success','warning','error','new_message','new_conversation') DEFAULT 'info',
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `conversation_id` (`conversation_id`),
  KEY `is_read` (`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sistem ayarları
CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL UNIQUE,
  `value` text DEFAULT NULL,
  `type` enum('string','number','boolean','json') DEFAULT 'string',
  `description` varchar(500) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Foreign key kısıtlamalarını tekrar aktif et
SET FOREIGN_KEY_CHECKS = 1;

-- Foreign key kısıtlamalarını ekle
ALTER TABLE `conversations` 
ADD CONSTRAINT `conversations_customer_fk` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE,
ADD CONSTRAINT `conversations_user_fk` FOREIGN KEY (`assigned_to`) REFERENCES `users` (`id`) ON DELETE CASCADE;

ALTER TABLE `messages` 
ADD CONSTRAINT `messages_conversation_fk` FOREIGN KEY (`conversation_id`) REFERENCES `conversations` (`id`) ON DELETE CASCADE,
ADD CONSTRAINT `messages_user_fk` FOREIGN KEY (`sender_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
ADD CONSTRAINT `messages_read_by_fk` FOREIGN KEY (`read_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;

ALTER TABLE `message_attachments` 
ADD CONSTRAINT `attachments_message_fk` FOREIGN KEY (`message_id`) REFERENCES `messages` (`id`) ON DELETE CASCADE;

ALTER TABLE `user_agencies` 
ADD CONSTRAINT `user_agencies_user_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
ADD CONSTRAINT `user_agencies_agency_fk` FOREIGN KEY (`agency_id`) REFERENCES `agencies` (`id`) ON DELETE CASCADE;

ALTER TABLE `notifications` 
ADD CONSTRAINT `notifications_user_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
ADD CONSTRAINT `notifications_conversation_fk` FOREIGN KEY (`conversation_id`) REFERENCES `conversations` (`id`) ON DELETE CASCADE;

-- Varsayılan ayarları ekle
INSERT IGNORE INTO `settings` (`key`, `value`, `type`, `description`) VALUES
('app_name', 'MultiCRM', 'string', 'Uygulama adı'),
('app_version', '1.0.0', 'string', 'Uygulama versiyonu'),
('timezone', 'Europe/Istanbul', 'string', 'Varsayılan saat dilimi'),
('whatsapp_webhook_verify_token', 'profaj_whatsapp_2024', 'string', 'WhatsApp webhook doğrulama tokenı'),
('whatsapp_phone_number_id', '592915763902531', 'string', 'WhatsApp telefon numarası ID'),
('whatsapp_business_account_id', '1368891014268764', 'string', 'WhatsApp işletme hesabı ID'),
('whatsapp_access_token', 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e', 'string', 'WhatsApp erişim tokenı'),
('whatsapp_api_version', 'v18.0', 'string', 'WhatsApp API versiyonu'),
('auto_assign_conversations', '1', 'boolean', 'Sohbetleri otomatik atama'),
('max_conversations_per_agent', '10', 'number', 'Ajan başına maksimum sohbet sayısı'),
('message_retention_days', '365', 'number', 'Mesaj saklama süresi (gün)');

-- Varsayılan admin kullanıcısı oluştur
INSERT IGNORE INTO `users` (`name`, `email`, `password`, `role`, `status`) VALUES
('Admin', 'admin@multicrm.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'active');

-- Varsayılan ajans oluştur
INSERT IGNORE INTO `agencies` (`name`, `domain`, `status`) VALUES
('MultiCRM', 'profaj.co', 'active');

-- Admin kullanıcısını varsayılan ajansa ata
INSERT IGNORE INTO `user_agencies` (`user_id`, `agency_id`, `role`) VALUES
(1, 1, 'owner');
