<?php
require_once '../config/database.php';

header('Content-Type: application/json');

$updates = [];
$overallSuccess = true;

try {
    // 1. Conversations tablosuna platform sütunu ekle
    try {
        $stmt = $pdo->query("DESCRIBE conversations");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (!in_array('platform', $columns)) {
            $pdo->exec("ALTER TABLE conversations ADD COLUMN platform ENUM('whatsapp', 'facebook') DEFAULT 'whatsapp' AFTER customer_id");
            $updates[] = [
                'title' => 'Conversations - platform sütunu',
                'message' => 'platform sütunu başarıyla eklendi',
                'success' => true
            ];
        } else {
            $updates[] = [
                'title' => 'Conversations - platform sütunu',
                'message' => 'platform sütunu zaten mevcut',
                'success' => true
            ];
        }
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Conversations - platform sütunu',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    // 2. Customers tablosuna facebook_id sütunu ekle
    try {
        $stmt = $pdo->query("DESCRIBE customers");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (!in_array('facebook_id', $columns)) {
            $pdo->exec("ALTER TABLE customers ADD COLUMN facebook_id VARCHAR(255) NULL AFTER email");
            $updates[] = [
                'title' => 'Customers - facebook_id sütunu',
                'message' => 'facebook_id sütunu başarıyla eklendi',
                'success' => true
            ];
        } else {
            $updates[] = [
                'title' => 'Customers - facebook_id sütunu',
                'message' => 'facebook_id sütunu zaten mevcut',
                'success' => true
            ];
        }
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Customers - facebook_id sütunu',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    // 3. Messages tablosu - message sütununu content'e dönüştür
    try {
        $stmt = $pdo->query("DESCRIBE messages");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (in_array('message', $columns) && !in_array('content', $columns)) {
            $pdo->exec("ALTER TABLE messages CHANGE COLUMN message content TEXT NOT NULL");
            $updates[] = [
                'title' => 'Messages - message → content',
                'message' => 'message sütunu content olarak yeniden adlandırıldı',
                'success' => true
            ];
        } elseif (!in_array('content', $columns)) {
            $pdo->exec("ALTER TABLE messages ADD COLUMN content TEXT NOT NULL AFTER conversation_id");
            $updates[] = [
                'title' => 'Messages - content sütunu',
                'message' => 'content sütunu başarıyla eklendi',
                'success' => true
            ];
        } else {
            $updates[] = [
                'title' => 'Messages - content sütunu',
                'message' => 'content sütunu zaten mevcut',
                'success' => true
            ];
        }
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Messages - content sütunu',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    // 4. Messages tablosu - message_type sütununu sender_type'a dönüştür
    try {
        $stmt = $pdo->query("DESCRIBE messages");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (!in_array('sender_type', $columns)) {
            $pdo->exec("ALTER TABLE messages ADD COLUMN sender_type ENUM('customer','agent','system') NOT NULL DEFAULT 'customer' AFTER content");
            $updates[] = [
                'title' => 'Messages - sender_type sütunu',
                'message' => 'sender_type sütunu başarıyla eklendi',
                'success' => true
            ];
        } else {
            $updates[] = [
                'title' => 'Messages - sender_type sütunu',
                'message' => 'sender_type sütunu zaten mevcut',
                'success' => true
            ];
        }
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Messages - sender_type sütunu',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    // 5. Activity_logs tablosu oluştur
    try {
        $stmt = $pdo->query("SHOW TABLES LIKE 'activity_logs'");
        if ($stmt->rowCount() == 0) {
            $pdo->exec("CREATE TABLE activity_logs (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id INT,
                action VARCHAR(255) NOT NULL,
                details TEXT,
                created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
            )");
            $updates[] = [
                'title' => 'Activity Logs Tablosu',
                'message' => 'activity_logs tablosu başarıyla oluşturuldu',
                'success' => true
            ];
        } else {
            $updates[] = [
                'title' => 'Activity Logs Tablosu',
                'message' => 'activity_logs tablosu zaten mevcut',
                'success' => true
            ];
        }
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Activity Logs Tablosu',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    // 6. Index'leri oluştur
    try {
        $indexes = [
            ['table' => 'conversations', 'name' => 'idx_conversations_platform', 'column' => 'platform'],
            ['table' => 'customers', 'name' => 'idx_customers_facebook_id', 'column' => 'facebook_id']
        ];
        
        foreach ($indexes as $index) {
            $stmt = $pdo->query("SHOW INDEX FROM {$index['table']} WHERE Key_name = '{$index['name']}'");
            if ($stmt->rowCount() == 0) {
                $pdo->exec("CREATE INDEX {$index['name']} ON {$index['table']}({$index['column']})");
            }
        }
        
        $updates[] = [
            'title' => 'Veritabanı Index\'leri',
            'message' => 'Tüm index\'ler başarıyla oluşturuldu',
            'success' => true
        ];
    } catch (PDOException $e) {
        $updates[] = [
            'title' => 'Veritabanı Index\'leri',
            'message' => 'Hata: ' . $e->getMessage(),
            'success' => false
        ];
        $overallSuccess = false;
    }
    
    echo json_encode([
        'success' => $overallSuccess,
        'updates' => $updates
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
