<?php
require_once '../config/database.php';

header('Content-Type: application/json');

try {
    $results = [];
    
    // Veritabanı bağlantısı kontrolü
    try {
        $pdo->query("SELECT 1");
        $results[] = ['success' => true, 'message' => 'Veritabanı bağlantısı başarılı'];
    } catch (Exception $e) {
        $results[] = ['success' => false, 'message' => 'Veritabanı bağlantı hatası: ' . $e->getMessage()];
    }
    
    // Facebook webhook dosyası kontrolü
    if (file_exists('../api/webhook-facebook.php')) {
        $results[] = ['success' => true, 'message' => 'Facebook webhook dosyası mevcut'];
    } else {
        $results[] = ['success' => false, 'message' => 'Facebook webhook dosyası bulunamadı'];
    }
    
    // Facebook send API dosyası kontrolü
    if (file_exists('../api/send-facebook-message.php')) {
        $results[] = ['success' => true, 'message' => 'Facebook send API dosyası mevcut'];
    } else {
        $results[] = ['success' => false, 'message' => 'Facebook send API dosyası bulunamadı'];
    }
    
    // Config dosyası kontrolü
    if (file_exists('../config/database.php')) {
        $results[] = ['success' => true, 'message' => 'Config dosyası mevcut'];
    } else {
        $results[] = ['success' => false, 'message' => 'Config dosyası bulunamadı'];
    }
    
    // Facebook config kontrolü
    if (isset($facebook_config) && !empty($facebook_config['app_id'])) {
        $results[] = ['success' => true, 'message' => 'Facebook API ayarları mevcut'];
    } else {
        $results[] = ['success' => false, 'message' => 'Facebook API ayarları eksik'];
    }
    
    echo json_encode([
        'success' => true,
        'results' => $results
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Sistem kontrolü sırasında hata: ' . $e->getMessage()
    ]);
}
?>
