<?php
// Facebook entegrasyonu için manuel veritabanı güncellemeleri
require_once '../config/database.php';

try {
    echo "Facebook entegrasyonu için veritabanı güncellemeleri başlatılıyor...\n";
    
    // Conversations tablosuna platform sütunu ekle
    try {
        $pdo->exec("ALTER TABLE conversations ADD COLUMN platform ENUM('whatsapp', 'facebook') DEFAULT 'whatsapp'");
        echo "✓ Conversations tablosuna platform sütunu eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "✓ Platform sütunu zaten mevcut\n";
        } else {
            echo "✗ Platform sütunu eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    // Customers tablosuna facebook_id sütunu ekle
    try {
        $pdo->exec("ALTER TABLE customers ADD COLUMN facebook_id VARCHAR(255) NULL");
        echo "✓ Customers tablosuna facebook_id sütunu eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "✓ Facebook_id sütunu zaten mevcut\n";
        } else {
            echo "✗ Facebook_id sütunu eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    // Messages tablosuna platform sütunu ekle
    try {
        $pdo->exec("ALTER TABLE messages ADD COLUMN platform ENUM('whatsapp', 'facebook') DEFAULT 'whatsapp'");
        echo "✓ Messages tablosuna platform sütunu eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
            echo "✓ Platform sütunu zaten mevcut\n";
        } else {
            echo "✗ Platform sütunu eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    // Index'leri ekle
    try {
        $pdo->exec("CREATE INDEX idx_conversations_platform ON conversations(platform)");
        echo "✓ Conversations platform index'i eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            echo "✓ Platform index'i zaten mevcut\n";
        } else {
            echo "✗ Platform index'i eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    try {
        $pdo->exec("CREATE INDEX idx_customers_facebook_id ON customers(facebook_id)");
        echo "✓ Customers facebook_id index'i eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            echo "✓ Facebook_id index'i zaten mevcut\n";
        } else {
            echo "✗ Facebook_id index'i eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    try {
        $pdo->exec("CREATE INDEX idx_messages_platform ON messages(platform)");
        echo "✓ Messages platform index'i eklendi\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') !== false) {
            echo "✓ Platform index'i zaten mevcut\n";
        } else {
            echo "✗ Platform index'i eklenirken hata: " . $e->getMessage() . "\n";
        }
    }
    
    // Activity logs tablosu oluştur
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS activity_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT,
            action VARCHAR(255),
            details TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )");
        echo "✓ Activity logs tablosu oluşturuldu\n";
    } catch (PDOException $e) {
        echo "✗ Activity logs tablosu oluşturulurken hata: " . $e->getMessage() . "\n";
    }
    
    echo "\n🎉 Facebook entegrasyonu için veritabanı güncellemeleri tamamlandı!\n";
    echo "Şimdi Facebook Developer Console'da webhook URL'ini ayarlayabilirsiniz:\n";
    echo "Webhook URL: https://profaj.co/multicrm/api/webhook-facebook.php\n";
    echo "Verify Token: profaj_whatsapp_2024\n";
    
} catch (Exception $e) {
    echo "✗ Genel hata: " . $e->getMessage() . "\n";
}
?>
