<?php
/**
 * Simple Column Fix - Direct SQL without checks
 * This will show exact error messages
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../config/database.php';

echo "<!DOCTYPE html>
<html lang='tr'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Simple Column Fix</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; max-width: 900px; margin: 50px auto; padding: 20px; background: #f5f7fa; }
        .container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
        h1 { color: #1f93ff; }
        .success { background: #dcfce7; color: #166534; padding: 12px; border-radius: 6px; margin: 10px 0; }
        .error { background: #fee2e2; color: #991b1b; padding: 12px; border-radius: 6px; margin: 10px 0; }
        .warning { background: #fef3c7; color: #92400e; padding: 12px; border-radius: 6px; margin: 10px 0; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 4px; overflow-x: auto; font-size: 12px; }
        .btn { background: #1f93ff; color: white; padding: 10px 20px; border: none; border-radius: 6px; cursor: pointer; font-size: 14px; font-weight: 600; text-decoration: none; display: inline-block; margin-top: 20px; }
    </style>
</head>
<body>
    <div class='container'>";

echo "<h1>🔧 Direct Column Addition</h1>";

// First, let's see what columns actually exist
echo "<h2>Current Columns in customers:</h2>";
try {
    $stmt = $pdo->query("DESCRIBE customers");
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<pre>" . implode("\n", $cols) . "</pre>";
} catch (PDOException $e) {
    echo "<div class='error'>" . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<h2>Current Columns in conversations:</h2>";
try {
    $stmt = $pdo->query("DESCRIBE conversations");
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<pre>" . implode("\n", $cols) . "</pre>";
} catch (PDOException $e) {
    echo "<div class='error'>" . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<hr><h2>Attempting to Add Columns</h2>";

// Try adding columns one by one with detailed error reporting
$updates = [
    "ALTER TABLE customers ADD COLUMN facebook_id VARCHAR(255) DEFAULT NULL",
    "ALTER TABLE customers ADD COLUMN instagram_id VARCHAR(255) DEFAULT NULL",
    "ALTER TABLE customers ADD COLUMN preferred_channel ENUM('whatsapp', 'facebook', 'instagram', 'any') DEFAULT 'any'",
    "ALTER TABLE customers ADD COLUMN last_seen_at TIMESTAMP NULL DEFAULT NULL",
    "ALTER TABLE conversations ADD COLUMN platform ENUM('whatsapp', 'facebook', 'instagram') DEFAULT 'whatsapp'",
    "ALTER TABLE conversations ADD COLUMN assignment_type ENUM('manual', 'auto', 'round_robin', 'load_balanced') DEFAULT 'auto'",
    "ALTER TABLE conversations ADD COLUMN assigned_at TIMESTAMP NULL DEFAULT NULL",
    "ALTER TABLE conversations ADD COLUMN first_response_time INT DEFAULT NULL",
    "ALTER TABLE conversations ADD COLUMN avg_response_time INT DEFAULT NULL"
];

foreach ($updates as $sql) {
    echo "<div style='margin: 15px 0;'>";
    echo "<strong>SQL:</strong> <code>" . htmlspecialchars($sql) . "</code><br>";
    
    try {
        $pdo->exec($sql);
        echo "<div class='success'>✅ Success</div>";
    } catch (PDOException $e) {
        $msg = $e->getMessage();
        if (strpos($msg, 'Duplicate column') !== false) {
            echo "<div class='warning'>⚠️ Column already exists (OK)</div>";
        } else {
            echo "<div class='error'>❌ Error: " . htmlspecialchars($msg) . "</div>";
        }
    }
    echo "</div>";
}

echo "<hr><h2>Final Verification</h2>";

echo "<h3>Customers table columns:</h3>";
try {
    $stmt = $pdo->query("DESCRIBE customers");
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<pre>" . implode("\n", $cols) . "</pre>";
    
    $required = ['facebook_id', 'instagram_id', 'preferred_channel', 'last_seen_at'];
    foreach ($required as $col) {
        if (in_array($col, $cols)) {
            echo "<div class='success'>✅ $col exists</div>";
        } else {
            echo "<div class='error'>❌ $col missing</div>";
        }
    }
} catch (PDOException $e) {
    echo "<div class='error'>" . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<h3>Conversations table columns:</h3>";
try {
    $stmt = $pdo->query("DESCRIBE conversations");
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<pre>" . implode("\n", $cols) . "</pre>";
    
    $required = ['platform', 'assignment_type', 'assigned_at', 'first_response_time'];
    foreach ($required as $col) {
        if (in_array($col, $cols)) {
            echo "<div class='success'>✅ $col exists</div>";
        } else {
            echo "<div class='error'>❌ $col missing</div>";
        }
    }
} catch (PDOException $e) {
    echo "<div class='error'>" . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<p><a href='check-database.php' class='btn'>Check Full Database Structure</a></p>";
echo "<p><a href='../index.php' class='btn'>Go to Dashboard</a></p>";

echo "</div></body></html>";
?>
