<?php
/**
 * MultiCRM - Sadece Tablo Kurulumu
 * Veritabanı mevcut, sadece tabloları oluşturur
 */

echo "<h2>MultiCRM - Tablo Kurulumu</h2>";
echo "<div style='background: #f8f9fa; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";

// Veritabanı bağlantı bilgileri
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];

echo "<h3>1. Veritabanı Bağlantısı</h3>";

try {
    // Veritabanına bağlan
    $dsn = "mysql:host={$db_config['host']};dbname={$db_config['dbname']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<p style='color: green;'>✓ Veritabanı bağlantısı başarılı: {$db_config['dbname']}</p>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24;'>";
    echo "<h4>❌ Veritabanı Bağlantı Hatası</h4>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p><strong>Çözüm:</strong> Veritabanı bilgilerini kontrol edin</p>";
    echo "</div>";
    exit();
}

echo "<h3>2. Mevcut Tabloları Kontrol Et</h3>";

// Mevcut tabloları listele
$stmt = $pdo->query("SHOW TABLES");
$existingTables = $stmt->fetchAll(PDO::FETCH_COLUMN);

if (empty($existingTables)) {
    echo "<p style='color: orange;'>⚠ Veritabanında tablo bulunamadı</p>";
} else {
    echo "<p style='color: green;'>✓ Mevcut tablolar:</p>";
    echo "<ul>";
    foreach ($existingTables as $table) {
        echo "<li>$table</li>";
    }
    echo "</ul>";
}

echo "<h3>3. Tabloları Oluştur</h3>";

// SQL dosyasını oku
$sqlFile = __DIR__ . '/database.sql';
if (!file_exists($sqlFile)) {
    echo "<div style='background: #f8d7da; padding: 1rem; border-radius: 5px; color: #721c24;'>";
    echo "<h4>❌ SQL Dosyası Bulunamadı</h4>";
    echo "<p>database.sql dosyası bulunamadı!</p>";
    echo "</div>";
    exit();
}

$sql = file_get_contents($sqlFile);
$statements = explode(';', $sql);

$successCount = 0;
$errorCount = 0;
$warnings = [];

echo "<div style='background: #e3f2fd; padding: 1rem; border-radius: 5px; margin: 1rem 0;'>";
echo "<h5>📋 Kurulum İşlemleri</h5>";
echo "<ul class='mb-0'>";
echo "<li>Kullanıcılar tablosu</li>";
echo "<li>Müşteriler tablosu</li>";
echo "<li>Sohbetler tablosu</li>";
echo "<li>Mesajlar tablosu</li>";
echo "<li>Bildirimler tablosu</li>";
echo "<li>Ajanslar tablosu</li>";
echo "<li>Sistem ayarları</li>";
echo "<li>Varsayılan veriler</li>";
echo "</ul>";
echo "</div>";

foreach ($statements as $statement) {
    $statement = trim($statement);
    if (!empty($statement)) {
        try {
            $pdo->exec($statement);
            $successCount++;
            
            // Tablo oluşturma mesajları
            if (stripos($statement, 'CREATE TABLE') !== false) {
                preg_match('/CREATE TABLE.*?`?(\w+)`?/i', $statement, $matches);
                $tableName = $matches[1] ?? 'Bilinmeyen';
                echo "<p style='color: green;'>✓ Tablo oluşturuldu: $tableName</p>";
            }
            
            // INSERT mesajları
            if (stripos($statement, 'INSERT INTO') !== false) {
                preg_match('/INSERT INTO.*?`?(\w+)`?/i', $statement, $matches);
                $tableName = $matches[1] ?? 'Bilinmeyen';
                echo "<p style='color: blue;'>✓ Veri eklendi: $tableName</p>";
            }
            
        } catch (PDOException $e) {
            $errorCount++;
            
            // Hata türüne göre mesaj
            if (strpos($e->getMessage(), 'already exists') !== false) {
                $warnings[] = "Tablo zaten mevcut: " . $e->getMessage();
            } else {
                echo "<p style='color: red;'>✗ Hata: " . $e->getMessage() . "</p>";
            }
        }
    }
}

echo "<h3>4. Kurulum Sonucu</h3>";

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724;'>";
echo "<h5>✅ Kurulum Başarılı!</h5>";
echo "<p><strong>Başarılı işlemler:</strong> $successCount</p>";
echo "<p><strong>Hatalar:</strong> $errorCount</p>";
echo "</div>";

if (!empty($warnings)) {
    echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; color: #856404; margin: 1rem 0;'>";
    echo "<h5>⚠️ Uyarılar</h5>";
    echo "<ul class='mb-0'>";
    foreach ($warnings as $warning) {
        echo "<li>$warning</li>";
    }
    echo "</ul>";
    echo "</div>";
}

// Tabloları kontrol et
echo "<h3>5. Oluşturulan Tablolar</h3>";

$stmt = $pdo->query("SHOW TABLES");
$tables = $stmt->fetchAll(PDO::FETCH_COLUMN);

$requiredTables = [
    'users' => 'Kullanıcılar',
    'customers' => 'Müşteriler', 
    'conversations' => 'Sohbetler',
    'messages' => 'Mesajlar',
    'notifications' => 'Bildirimler',
    'agencies' => 'Ajanslar',
    'settings' => 'Ayarlar'
];

echo "<div class='row'>";
foreach ($requiredTables as $table => $name) {
    $exists = in_array($table, $tables);
    $icon = $exists ? 'fa-check-circle text-success' : 'fa-times-circle text-danger';
    $bgClass = $exists ? 'bg-light' : 'bg-danger bg-opacity-10';
    
    echo "<div class='col-md-6 mb-2'>";
    echo "<div class='card $bgClass'>";
    echo "<div class='card-body p-2'>";
    echo "<i class='fas $icon'></i> <strong>$name</strong> ($table)";
    echo "</div>";
    echo "</div>";
    echo "</div>";
}
echo "</div>";

// Varsayılan admin kullanıcısını kontrol et
echo "<h3>6. Varsayılan Kullanıcı</h3>";

try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM users WHERE email = 'admin@multicrm.com'");
    $stmt->execute();
    $adminExists = $stmt->fetch()['count'] > 0;
    
    if ($adminExists) {
        echo "<p style='color: green;'>✓ Varsayılan admin kullanıcısı mevcut</p>";
        echo "<p><strong>Email:</strong> admin@multicrm.com</p>";
        echo "<p><strong>Şifre:</strong> password</p>";
    } else {
        echo "<p style='color: orange;'>⚠ Varsayılan admin kullanıcısı bulunamadı</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Kullanıcı kontrolü hatası: " . $e->getMessage() . "</p>";
}

echo "<h3>7. Kurulum Tamamlandı! 🎉</h3>";

echo "<div style='background: #d4edda; padding: 1rem; border-radius: 5px; color: #155724;'>";
echo "<h5>✅ MultiCRM Tabloları Başarıyla Oluşturuldu!</h5>";
echo "<p>Sistem kullanıma hazır.</p>";
echo "</div>";

echo "<h4>📋 Sonraki Adımlar:</h4>";
echo "<ol>";
echo "<li><strong>Giriş Yapın:</strong> <a href='../login.php' target='_blank'>https://profaj.co/multicrm/login.php</a></li>";
echo "<li><strong>Varsayılan Giriş:</strong> admin@multicrm.com / password</li>";
echo "<li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>";
echo "<li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>";
echo "<li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>";
echo "</ol>";

echo "<div style='background: #fff3cd; padding: 1rem; border-radius: 5px; color: #856404; margin: 1rem 0;'>";
echo "<h6>🔒 Güvenlik Uyarısı</h6>";
echo "<p><strong>Önemli:</strong> İlk girişten sonra admin şifresini değiştirin!</p>";
echo "<p>Varsayılan şifre: <code>password</code></p>";
echo "</div>";

echo "<p><a href='../index.php' class='btn btn-primary'>Ana Sayfaya Git</a></p>";

echo "</div>";
?>
