<?php
// Tüm hataları göster
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('max_execution_time', 5); // 5 saniye timeout

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔧 HIZLI DÜZELTME\n";
echo "═══════════════════════════════════════════════════════════\n\n";

try {
    echo "1. Database yükleniyor...\n";
    require_once 'config/database.php';
    echo "✅ Database OK\n\n";
    
    echo "2. Functions yükleniyor...\n";
    require_once 'includes/functions.php';
    echo "✅ Functions OK\n\n";
    
    echo "3. Session başlatılıyor...\n";
    session_start();
    echo "✅ Session OK\n\n";
    
    echo "4. Login kontrolü...\n";
    if (!isset($_SESSION['user_id'])) {
        echo "❌ Giriş yapılmamış\n";
        echo "Login sayfası: https://profaj.co/multicrm/login.php\n\n";
    } else {
        echo "✅ User ID: " . $_SESSION['user_id'] . "\n\n";
        
        echo "5. Kullanıcı bilgisi çekiliyor...\n";
        $user = getUserById($_SESSION['user_id']);
        if ($user) {
            echo "✅ Kullanıcı: " . $user['name'] . "\n\n";
        } else {
            echo "❌ Kullanıcı bulunamadı\n\n";
        }
        
        echo "6. Sohbetler yükleniyor (TIMEOUT: 5 saniye)...\n";
        $start = microtime(true);
        $conversations = getActiveConversations($_SESSION['user_id']);
        $duration = microtime(true) - $start;
        echo "✅ Sohbet sayısı: " . count($conversations) . "\n";
        echo "✅ Süre: " . round($duration, 2) . " saniye\n\n";
    }
    
    echo "═══════════════════════════════════════════════════════════\n";
    echo "✅ TÜM TESTLER BAŞARILI!\n";
    echo "\nCRM'i deneyin: https://profaj.co/multicrm/\n";
    echo "═══════════════════════════════════════════════════════════\n";
    
} catch (Exception $e) {
    echo "\n❌ HATA:\n";
    echo "Mesaj: " . $e->getMessage() . "\n";
    echo "Dosya: " . $e->getFile() . "\n";
    echo "Satır: " . $e->getLine() . "\n";
}
?>

