<?php
/**
 * Facebook Page ID Hızlı Güncelleme
 */

require_once 'config/database.php';

$pageId = '156971014411976';
$token = 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e';

echo "<h1>🚀 Facebook Ayarları Güncelleniyor...</h1>";

try {
    // Page ID güncelle
    $stmt = $pdo->prepare("UPDATE settings SET value = ?, updated_at = NOW() WHERE `key` = 'facebook_page_id'");
    $stmt->execute([$pageId]);
    echo "<p>✅ Page ID güncellendi: <strong>$pageId</strong></p>";
    
    // Access Token güncelle
    $stmt = $pdo->prepare("UPDATE settings SET value = ?, updated_at = NOW() WHERE `key` = 'facebook_page_access_token'");
    $stmt->execute([$token]);
    echo "<p>✅ Access Token güncellendi</p>";
    
    // Tüm Facebook ayarlarını göster
    echo "<hr>";
    echo "<h2>📊 Facebook Ayarları:</h2>";
    
    $stmt = $pdo->prepare("SELECT `key`, `value` FROM settings WHERE `key` LIKE 'facebook_%' ORDER BY `key`");
    $stmt->execute();
    $settings = $stmt->fetchAll();
    
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f0f0f0;'><th>Ayar</th><th>Değer</th><th>Durum</th></tr>";
    
    foreach ($settings as $setting) {
        $key = str_replace('facebook_', '', $setting['key']);
        $value = $setting['value'];
        $display = $value ? (strlen($value) > 60 ? substr($value, 0, 60) . '...' : $value) : '<span style="color: red;">BOŞ</span>';
        $status = $value ? '✅' : '❌';
        
        echo "<tr>";
        echo "<td><strong>" . htmlspecialchars($key) . "</strong></td>";
        echo "<td style='font-family: monospace; font-size: 12px;'>" . $display . "</td>";
        echo "<td style='text-align: center;'>" . $status . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Test bağlantıları
    echo "<hr>";
    echo "<h2>🧪 Test Araçları:</h2>";
    echo "<div style='background: #e3f2fd; padding: 20px; border-radius: 8px;'>";
    echo "<h3>1. Webhook Doğrulama Testi</h3>";
    echo "<p><a href='https://profaj.co/multicrm/api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123' target='_blank' style='background: #1877f2; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;'>🔗 Webhook Test Et</a></p>";
    echo "<p><small>Beklenen sonuç: <code>test123</code></small></p>";
    echo "</div>";
    
    echo "<div style='background: #f3e5f5; padding: 20px; border-radius: 8px; margin-top: 20px;'>";
    echo "<h3>2. Manuel Mesaj Testi</h3>";
    echo "<p><a href='test-facebook-message.php' style='background: #9c27b0; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px;'>📝 Test Sayfası</a></p>";
    echo "</div>";
    
    // Facebook Developer Console Talimatları
    echo "<hr>";
    echo "<h2>📋 Facebook Developer Console Ayarları:</h2>";
    echo "<div style='background: #fff3cd; padding: 20px; border-radius: 8px;'>";
    echo "<ol style='line-height: 2;'>";
    echo "<li>Facebook Developer Console → <strong>Webhooks</strong> bölümüne git</li>";
    echo "<li><strong>Webhook URL:</strong> <code style='background: #000; color: #0f0; padding: 5px;'>https://profaj.co/multicrm/api/webhook-facebook.php</code></li>";
    echo "<li><strong>Verify Token:</strong> <code style='background: #000; color: #0f0; padding: 5px;'>profaj_whatsapp_2024</code></li>";
    echo "<li><strong>Subscribe Fields:</strong>";
    echo "<ul>";
    echo "<li>✅ <code>messages</code></li>";
    echo "<li>✅ <code>messaging_postbacks</code></li>";
    echo "</ul>";
    echo "</li>";
    echo "<li><strong>Page:</strong> Sayfanızı seçin (ID: $pageId)</li>";
    echo "<li><strong>Subscribe</strong> butonuna tıklayın</li>";
    echo "</ol>";
    echo "</div>";
    
    // Gerçek Mesaj Testi
    echo "<hr>";
    echo "<h2>💬 Gerçek Mesaj Testi:</h2>";
    echo "<div style='background: #e8f5e9; padding: 20px; border-radius: 8px;'>";
    echo "<ol>";
    echo "<li>Facebook Sayfanızdan başka bir hesaptan mesaj gönderin</li>";
    echo "<li>Log dosyasını kontrol edin: <code>logs/facebook_webhook_" . date('Y-m-d') . ".log</code></li>";
    echo "<li>CRM panelinde mesajın görünüp görünmediğini kontrol edin: <a href='index.php'>Ana Sayfa</a></li>";
    echo "</ol>";
    echo "</div>";
    
    echo "<hr>";
    echo "<div style='text-align: center; padding: 20px;'>";
    echo "<h2>✅ Facebook Entegrasyonu Hazır!</h2>";
    echo "<p><a href='index.php' style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; font-size: 18px;'>🏠 Ana Sayfaya Git</a></p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background: #ffebee; padding: 20px; border-radius: 8px; color: #c62828;'>";
    echo "<h2>❌ Hata!</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

