<?php
session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';

// Eğer kullanıcı giriş yapmamışsa login sayfasına yönlendir
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$user_id = $_SESSION['user_id'];
$user = getUserById($user_id);

// Sadece admin ve supervisor erişebilir
if (!in_array($user['role'], ['admin', 'supervisor'])) {
    header('Location: index.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>API Ayarları - MultiCRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .settings-card {
            transition: all 0.3s ease;
        }
        .settings-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
        }
        .form-label {
            font-weight: 600;
            color: #495057;
        }
        .encrypted-badge {
            font-size: 0.7rem;
            vertical-align: middle;
            margin-left: 5px;
        }
        .save-btn {
            min-width: 120px;
        }
        .alert-floating {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 9999;
            min-width: 300px;
            animation: slideInRight 0.3s ease;
        }
        @keyframes slideInRight {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    </style>
</head>
<body>
    <?php include 'includes/sidebar.php'; ?>
    
    <div class="main-content">
        <div class="container-fluid mt-5">
            <h2 class="header-info-mini mb-4">
                <i class="fas fa-cogs"></i> API Ayarları
            </h2>

            <div class="row">
                <!-- WhatsApp Ayarları -->
                <div class="col-lg-6 mb-4">
                    <div class="card settings-card shadow-sm">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fab fa-whatsapp"></i> WhatsApp Business API
                            </h5>
                        </div>
                        <div class="card-body">
                            <form id="whatsappForm">
                                <div class="mb-3">
                                    <label for="wa_phone_number_id" class="form-label">
                                        Phone Number ID
                                    </label>
                                    <input type="text" class="form-control" id="wa_phone_number_id" 
                                           value="<?php echo htmlspecialchars($whatsapp_config['phone_number_id']); ?>" 
                                           required>
                                </div>

                                <div class="mb-3">
                                    <label for="wa_business_account_id" class="form-label">
                                        Business Account ID
                                    </label>
                                    <input type="text" class="form-control" id="wa_business_account_id" 
                                           value="<?php echo htmlspecialchars($whatsapp_config['business_account_id']); ?>" 
                                           required>
                                </div>

                                <div class="mb-3">
                                    <label for="wa_access_token" class="form-label">
                                        Access Token
                                        <span class="badge bg-warning encrypted-badge">
                                            <i class="fas fa-lock"></i> Şifreli
                                        </span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="wa_access_token" 
                                               value="<?php echo htmlspecialchars($whatsapp_config['access_token']); ?>" 
                                               required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('wa_access_token')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted">Meta Developer Console'dan alınır</small>
                                </div>

                                <div class="mb-3">
                                    <label for="wa_api_version" class="form-label">
                                        API Version
                                    </label>
                                    <input type="text" class="form-control" id="wa_api_version" 
                                           value="<?php echo htmlspecialchars($whatsapp_config['api_version']); ?>" 
                                           placeholder="v18.0" required>
                                </div>

                                <div class="mb-3">
                                    <label for="wa_verify_token" class="form-label">
                                        Verify Token
                                    </label>
                                    <input type="text" class="form-control" id="wa_verify_token" 
                                           value="<?php echo htmlspecialchars($whatsapp_config['verify_token']); ?>" 
                                           required>
                                    <small class="text-muted">Webhook doğrulama için kullanılır</small>
                                </div>

                                <div class="mb-3">
                                    <label for="wa_webhook_url" class="form-label">
                                        Webhook URL
                                    </label>
                                    <input type="url" class="form-control" id="wa_webhook_url" 
                                           value="<?php echo htmlspecialchars($whatsapp_config['webhook_url']); ?>" 
                                           required>
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-success save-btn">
                                        <i class="fas fa-save"></i> Kaydet
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Facebook Messenger Ayarları -->
                <div class="col-lg-6 mb-4">
                    <div class="card settings-card shadow-sm">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">
                                <i class="fab fa-facebook-messenger"></i> Facebook Messenger API
                            </h5>
                        </div>
                        <div class="card-body">
                            <form id="facebookForm">
                                <div class="mb-3">
                                    <label for="fb_app_id" class="form-label">
                                        App ID
                                    </label>
                                    <input type="text" class="form-control" id="fb_app_id" 
                                           value="<?php echo htmlspecialchars($facebook_config['app_id']); ?>" 
                                           required>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_app_secret" class="form-label">
                                        App Secret
                                        <span class="badge bg-warning encrypted-badge">
                                            <i class="fas fa-lock"></i> Şifreli
                                        </span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="fb_app_secret" 
                                               value="<?php echo htmlspecialchars($facebook_config['app_secret']); ?>" 
                                               required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('fb_app_secret')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted">Facebook Developer Console'dan alınır</small>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_page_id" class="form-label">
                                        Page ID
                                    </label>
                                    <input type="text" class="form-control" id="fb_page_id" 
                                           value="<?php echo htmlspecialchars($facebook_config['page_id']); ?>">
                                    <small class="text-muted">Facebook Sayfa ID'si (opsiyonel)</small>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_page_access_token" class="form-label">
                                        Page Access Token
                                        <span class="badge bg-warning encrypted-badge">
                                            <i class="fas fa-lock"></i> Şifreli
                                        </span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="fb_page_access_token" 
                                               value="<?php echo htmlspecialchars($facebook_config['page_access_token']); ?>" 
                                               required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('fb_page_access_token')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted">Sayfa erişim tokenı</small>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_api_version" class="form-label">
                                        API Version
                                    </label>
                                    <input type="text" class="form-control" id="fb_api_version" 
                                           value="<?php echo htmlspecialchars($facebook_config['api_version']); ?>" 
                                           placeholder="v18.0" required>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_verify_token" class="form-label">
                                        Verify Token
                                    </label>
                                    <input type="text" class="form-control" id="fb_verify_token" 
                                           value="<?php echo htmlspecialchars($facebook_config['verify_token']); ?>" 
                                           required>
                                    <small class="text-muted">Webhook doğrulama için kullanılır</small>
                                </div>

                                <div class="mb-3">
                                    <label for="fb_webhook_url" class="form-label">
                                        Webhook URL
                                    </label>
                                    <input type="url" class="form-control" id="fb_webhook_url" 
                                           value="<?php echo htmlspecialchars($facebook_config['webhook_url']); ?>" 
                                           required>
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary save-btn">
                                        <i class="fas fa-save"></i> Kaydet
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Instagram Ayarları -->
                <div class="col-lg-6 mb-4">
                    <div class="card settings-card shadow-sm">
                        <div class="card-header text-white" style="background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);">
                            <h5 class="mb-0">
                                <i class="fab fa-instagram"></i> Instagram Messaging API
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> Instagram, Facebook Graph API kullanır. 
                                <strong>Facebook ayarlarındaki Page Access Token</strong> Instagram için de geçerlidir.
                            </div>
                            
                            <form id="instagramForm">
                                <div class="mb-3">
                                    <label for="ig_business_account_id" class="form-label">
                                        Instagram Business Account ID
                                    </label>
                                    <input type="text" class="form-control" id="ig_business_account_id" 
                                           value="<?php echo htmlspecialchars($instagram_config['business_account_id'] ?? ''); ?>">
                                    <small class="text-muted">Instagram Business hesap ID'si</small>
                                </div>

                                <div class="mb-3">
                                    <label for="ig_verify_token" class="form-label">
                                        Verify Token
                                    </label>
                                    <input type="text" class="form-control" id="ig_verify_token" 
                                           value="<?php echo htmlspecialchars($instagram_config['verify_token'] ?? 'profaj_whatsapp_2024'); ?>" 
                                           required>
                                    <small class="text-muted">Webhook doğrulama için (WhatsApp ile aynı)</small>
                                </div>

                                <div class="mb-3">
                                    <label for="ig_webhook_url" class="form-label">
                                        Webhook URL
                                    </label>
                                    <input type="url" class="form-control" id="ig_webhook_url" 
                                           value="<?php echo htmlspecialchars($instagram_config['webhook_url'] ?? 'https://profaj.co/multicrm/api/webhook-instagram.php'); ?>" 
                                           required>
                                </div>

                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i> 
                                    <strong>Önemli:</strong> Instagram DM için Facebook App'inize 
                                    <code>instagram_manage_messages</code> izni eklenmelidir.
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn text-white save-btn" style="background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);">
                                        <i class="fas fa-save"></i> Kaydet
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Google Gemini AI Ayarları -->
                <div class="col-lg-6 mb-4">
                    <div class="card settings-card shadow-sm">
                        <div class="card-header text-white" style="background: linear-gradient(135deg, #4285f4 0%, #34a853 33%, #fbbc05 66%, #ea4335 100%);">
                            <h5 class="mb-0">
                                <i class="fas fa-robot"></i> Google Gemini AI
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-light border">
                                <i class="fas fa-magic text-primary"></i> 
                                <strong>Google AI Studio</strong> ile sohbetlerinize yapay zeka desteği ekleyin.
                            </div>
                            
                            <form id="googleAiForm">
                                <div class="mb-3">
                                    <label for="google_gemini_api_key" class="form-label">
                                        Gemini API Key
                                        <span class="badge bg-warning encrypted-badge">
                                            <i class="fas fa-lock"></i> Şifreli
                                        </span>
                                    </label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="google_gemini_api_key" 
                                               value="<?php echo htmlspecialchars($google_ai_config['api_key'] ?? ''); ?>" 
                                               required>
                                        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword('google_gemini_api_key')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted"><a href="https://aistudio.google.com/app/apikey" target="_blank">Google AI Studio</a>'dan alabilirsiniz.</small>
                                </div>

                                <div class="mb-3">
                                    <label for="google_gemini_model" class="form-label">
                                        Model
                                    </label>
                                    <select class="form-select" id="google_gemini_model">
                                        <option value="gemini-2.0-flash" <?php echo ($google_ai_config['model'] ?? '') === 'gemini-2.0-flash' ? 'selected' : ''; ?>>Gemini 2.0 Flash (En Yeni & Hızlı)</option>
                                        <option value="gemini-1.5-flash" <?php echo ($google_ai_config['model'] ?? '') === 'gemini-1.5-flash' ? 'selected' : ''; ?>>Gemini 1.5 Flash</option>
                                        <option value="gemini-1.5-pro" <?php echo ($google_ai_config['model'] ?? '') === 'gemini-1.5-pro' ? 'selected' : ''; ?>>Gemini 1.5 Pro</option>
                                        <option value="gemini-pro" <?php echo ($google_ai_config['model'] ?? '') === 'gemini-pro' ? 'selected' : ''; ?>>Gemini 1.0 Pro</option>
                                    </select>
                                </div>


                                <div class="alert alert-info border-0">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>Not:</strong> Sistem talimatları artık <strong>Chatbot AI</strong> sayfasında her chatbot için ayrı ayrı yönetiliyor.
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn text-white save-btn" style="background: linear-gradient(135deg, #4285f4 0%, #34a853 33%, #fbbc05 66%, #ea4335 100%);">
                                        <i class="fas fa-save"></i> Kaydet
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Bilgi Kartı -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card shadow-sm">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-info-circle"></i> Önemli Bilgiler
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6><i class="fas fa-shield-alt text-success"></i> Güvenlik</h6>
                                    <ul>
                                        <li>Hassas veriler (token, secret) veritabanında <strong>şifreli</strong> olarak saklanır</li>
                                        <li>Sadece admin ve supervisor rolündeki kullanıcılar bu sayfaya erişebilir</li>
                                        <li>Tüm değişiklikler güvenli bir şekilde kaydedilir</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6><i class="fas fa-book text-primary"></i> Dokümantasyon</h6>
                                    <ul>
                                        <li><a href="FACEBOOK_MESSENGER_SETUP.md" target="_blank">Facebook Messenger Kurulum Kılavuzu</a></li>
                                        <li><a href="test-facebook.php">Facebook Messenger Test Sayfası</a></li>
                                        <li>API anahtarlarınızı Meta Developer Console'dan alabilirsiniz</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Şifre göster/gizle
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = event.target.closest('button').querySelector('i');
            
            if (field.type === 'password') {
                field.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                field.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }

        // Floating alert göster
        function showAlert(message, type = 'success') {
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert alert-${type} alert-dismissible fade show alert-floating`;
            alertDiv.innerHTML = `
                ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.body.appendChild(alertDiv);
            
            setTimeout(() => {
                alertDiv.remove();
            }, 5000);
        }

        // WhatsApp form submit
        document.getElementById('whatsappForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const submitBtn = e.target.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Kaydediliyor...';
            
            const data = {
                platform: 'whatsapp',
                phone_number_id: document.getElementById('wa_phone_number_id').value,
                business_account_id: document.getElementById('wa_business_account_id').value,
                access_token: document.getElementById('wa_access_token').value,
                api_version: document.getElementById('wa_api_version').value,
                verify_token: document.getElementById('wa_verify_token').value,
                webhook_url: document.getElementById('wa_webhook_url').value
            };
            
            try {
                const response = await fetch('api/save-settings.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showAlert('<i class="fas fa-check-circle"></i> ' + result.message, 'success');
                } else {
                    showAlert('<i class="fas fa-exclamation-circle"></i> ' + result.message, 'danger');
                }
            } catch (error) {
                showAlert('<i class="fas fa-exclamation-triangle"></i> Bir hata oluştu: ' + error.message, 'danger');
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });

        // Facebook form submit
        document.getElementById('facebookForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const submitBtn = e.target.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Kaydediliyor...';
            
            const data = {
                platform: 'facebook',
                app_id: document.getElementById('fb_app_id').value,
                app_secret: document.getElementById('fb_app_secret').value,
                page_id: document.getElementById('fb_page_id').value,
                page_access_token: document.getElementById('fb_page_access_token').value,
                api_version: document.getElementById('fb_api_version').value,
                verify_token: document.getElementById('fb_verify_token').value,
                webhook_url: document.getElementById('fb_webhook_url').value
            };
            
            try {
                const response = await fetch('api/save-settings.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showAlert('<i class="fas fa-check-circle"></i> ' + result.message, 'success');
                } else {
                    showAlert('<i class="fas fa-exclamation-circle"></i> ' + result.message, 'danger');
                }
            } catch (error) {
                showAlert('<i class="fas fa-exclamation-triangle"></i> Bir hata oluştu: ' + error.message, 'danger');
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });

        // Instagram form submit
        document.getElementById('instagramForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const submitBtn = e.target.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Kaydediliyor...';
            
            const data = {
                platform: 'instagram',
                business_account_id: document.getElementById('ig_business_account_id').value,
                verify_token: document.getElementById('ig_verify_token').value,
                webhook_url: document.getElementById('ig_webhook_url').value
            };
            
            try {
                const response = await fetch('api/save-settings.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showAlert('<i class="fas fa-check-circle"></i> ' + result.message, 'success');
                } else {
                    showAlert('<i class="fas fa-exclamation-circle"></i> ' + result.message, 'danger');
                }
            } catch (error) {
                showAlert('<i class="fas fa-exclamation-triangle"></i> Bir hata oluştu: ' + error.message, 'danger');
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });
        // Google AI form submit
        document.getElementById('googleAiForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const submitBtn = e.target.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Kaydediliyor...';
            
            const data = {
                platform: 'google_ai',
                api_key: document.getElementById('google_gemini_api_key').value,
                model: document.getElementById('google_gemini_model').value,
                system_instruction: document.getElementById('ai_system_instruction').value
            };
            
            try {
                const response = await fetch('api/save-settings.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showAlert('<i class="fas fa-check-circle"></i> ' + result.message, 'success');
                } else {
                    showAlert('<i class="fas fa-exclamation-circle"></i> ' + result.message, 'danger');
                }
            } catch (error) {
                showAlert('<i class="fas fa-exclamation-triangle"></i> Bir hata oluştu: ' + error.message, 'danger');
            } finally {
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalText;
            }
        });
    </script>
</body>
</html>
