<?php
session_start();

// Basit güvenlik kontrolü
$setup_password = 'profaj2024';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['password']) && $_POST['password'] === $setup_password) {
        $_SESSION['setup_authenticated'] = true;
    }
    
    if (isset($_SESSION['setup_authenticated']) && isset($_POST['save_config'])) {
        $app_id = $_POST['app_id'] ?? '';
        $app_secret = $_POST['app_secret'] ?? '';
        $page_access_token = $_POST['page_access_token'] ?? '';
        
        $config_content = "<?php
/**
 * Facebook Messenger Configuration
 */

\$facebook_config = [
    // Facebook App Bilgileri
    'app_id' => '{$app_id}',
    'app_secret' => '{$app_secret}',
    
    // Page Access Token
    'page_access_token' => '{$page_access_token}',
    
    // Webhook Ayarları
    'verify_token' => 'profaj_whatsapp_2024',
    'webhook_url' => 'https://profaj.co/multicrm/api/webhook-facebook.php',
    
    // API Ayarları
    'api_version' => 'v18.0',
    'graph_api_url' => 'https://graph.facebook.com/v18.0',
    
    // Webhook Events
    'webhook_events' => [
        'messages',
        'messaging_postbacks',
        'message_deliveries',
        'message_reads'
    ],
    
    // Debug Mode
    'debug' => true,
];
?>";
        
        if (file_put_contents('config/facebook.php', $config_content)) {
            $success = "✅ Konfigürasyon başarıyla kaydedildi!";
        } else {
            $error = "❌ Dosya yazılamadı! İzinleri kontrol edin.";
        }
    }
}

$authenticated = isset($_SESSION['setup_authenticated']) && $_SESSION['setup_authenticated'];

// Mevcut config'i oku
$current_config = [];
if (file_exists('config/facebook.php')) {
    require_once 'config/facebook.php';
    if (isset($facebook_config)) {
        $current_config = $facebook_config;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook Messenger Kurulum</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 50px 0; }
        .setup-card { max-width: 800px; margin: 0 auto; }
        .code-block { background: #f8f9fa; padding: 15px; border-radius: 5px; font-family: monospace; font-size: 14px; }
        .step-number { background: #667eea; color: white; width: 30px; height: 30px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; font-weight: bold; margin-right: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="setup-card">
            <?php if (!$authenticated): ?>
                <!-- Giriş Formu -->
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><i class="fab fa-facebook-messenger"></i> Facebook Messenger Kurulum</h4>
                    </div>
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label class="form-label">Kurulum Şifresi:</label>
                                <input type="password" name="password" class="form-control" required>
                                <small class="text-muted">Şifre: profaj2024</small>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-unlock"></i> Devam Et
                            </button>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <!-- Kurulum Formu -->
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0"><i class="fab fa-facebook-messenger"></i> Facebook Messenger Konfigürasyonu</h4>
                    </div>
                    <div class="card-body">
                        <?php if (isset($success)): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
                                <hr>
                                <a href="debug-facebook-webhook.php" class="btn btn-sm btn-success">
                                    <i class="fas fa-check"></i> Kurulumu Kontrol Et
                                </a>
                                <a href="index.php" class="btn btn-sm btn-primary">
                                    <i class="fas fa-home"></i> Ana Sayfaya Dön
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="alert alert-info">
                            <h5><i class="fas fa-info-circle"></i> Kurulum Adımları:</h5>
                            <ol class="mb-0">
                                <li>Facebook Developer Console'a gidin: <a href="https://developers.facebook.com/" target="_blank">developers.facebook.com</a></li>
                                <li>Uygulamanızı seçin veya yeni uygulama oluşturun</li>
                                <li>Messenger ürününü ekleyin</li>
                                <li>Aşağıdaki bilgileri alın ve forma girin</li>
                            </ol>
                        </div>
                        
                        <form method="POST">
                            <input type="hidden" name="save_config" value="1">
                            
                            <div class="mb-3">
                                <label class="form-label">
                                    <span class="step-number">1</span>
                                    <strong>App ID:</strong>
                                </label>
                                <input type="text" name="app_id" class="form-control" 
                                       value="<?php echo htmlspecialchars($current_config['app_id'] ?? ''); ?>" 
                                       placeholder="Örnek: 1234567890123456" required>
                                <small class="text-muted">Developer Console → Settings → Basic → App ID</small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">
                                    <span class="step-number">2</span>
                                    <strong>App Secret:</strong>
                                </label>
                                <input type="text" name="app_secret" class="form-control" 
                                       value="<?php echo htmlspecialchars($current_config['app_secret'] ?? ''); ?>" 
                                       placeholder="Örnek: 1a2b3c4d5e6f7g8h9i0j" required>
                                <small class="text-muted">Developer Console → Settings → Basic → App Secret (Show butonuna tıklayın)</small>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label">
                                    <span class="step-number">3</span>
                                    <strong>Page Access Token:</strong>
                                </label>
                                <textarea name="page_access_token" class="form-control" rows="3" 
                                          placeholder="Örnek: EAAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" required><?php echo htmlspecialchars($current_config['page_access_token'] ?? ''); ?></textarea>
                                <small class="text-muted">Messenger → Settings → Access Tokens → Generate Token</small>
                            </div>
                            
                            <hr>
                            
                            <div class="alert alert-warning">
                                <h6><i class="fas fa-exclamation-triangle"></i> Webhook Ayarları:</h6>
                                <p class="mb-2">Facebook Developer Console'da şu bilgileri kullanın:</p>
                                <div class="code-block">
                                    <strong>Callback URL:</strong><br>
                                    https://profaj.co/multicrm/api/webhook-facebook.php<br><br>
                                    <strong>Verify Token:</strong><br>
                                    profaj_whatsapp_2024<br><br>
                                    <strong>Subscribe to fields:</strong><br>
                                    ✅ messages<br>
                                    ✅ messaging_postbacks<br>
                                    ✅ message_deliveries<br>
                                    ✅ message_reads
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary btn-lg w-100">
                                <i class="fas fa-save"></i> Konfigürasyonu Kaydet
                            </button>
                        </form>
                        
                        <hr>
                        
                        <div class="text-center">
                            <a href="FACEBOOK_MESSENGER_SETUP.md" target="_blank" class="btn btn-outline-secondary">
                                <i class="fas fa-book"></i> Detaylı Kurulum Kılavuzu
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

