<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📸 Instagram Entegrasyonu Kurulumu</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1000px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
        }
        .header h1 {
            background: linear-gradient(135deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-size: 42px;
            margin-bottom: 10px;
        }
        .step {
            background: #f8f9fa;
            padding: 25px;
            margin: 20px 0;
            border-radius: 12px;
            border-left: 5px solid #dc2743;
        }
        .step h3 {
            color: #dc2743;
            margin-bottom: 15px;
        }
        .code-box {
            background: #2d2d2d;
            color: #f8f8f2;
            padding: 20px;
            border-radius: 8px;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
            overflow-x: auto;
            font-size: 14px;
        }
        .btn {
            display: inline-block;
            padding: 18px 40px;
            background: linear-gradient(135deg, #f09433 0%,#dc2743 50%,#bc1888 100%);
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-weight: bold;
            font-size: 18px;
            margin: 10px 10px 10px 0;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
        }
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(220, 39, 67, 0.4);
        }
        .warning {
            background: #fff3cd;
            border-left: 5px solid #ffc107;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .success {
            background: #d4edda;
            border-left: 5px solid #28a745;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
        .info {
            background: #d1ecf1;
            border-left: 5px solid #17a2b8;
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📸 Instagram Entegrasyonu</h1>
            <p style="color: #666; font-size: 18px;">Instagram Direct Messages için CRM Kurulumu</p>
        </div>

        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install'])) {
            require_once 'config/database.php';
            
            echo "<div class='step'>";
            echo "<h3>🔧 Kurulum Başlıyor...</h3>";
            
            // 1. Veritabanı kolonunu ekle
            echo "<p><strong>1️⃣ Veritabanı güncelleniyor...</strong></p>";
            try {
                $pdo->exec("ALTER TABLE customers ADD COLUMN instagram_id VARCHAR(255) DEFAULT NULL");
                echo "<div class='success'>✅ instagram_id kolonu eklendi</div>";
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'duplicate column') !== false || strpos($e->getMessage(), 'Duplicate column') !== false) {
                    echo "<div class='info'>ℹ️ instagram_id kolonu zaten mevcut</div>";
                } else {
                    echo "<div class='warning'>⚠️ Hata: " . $e->getMessage() . "</div>";
                }
            }
            
            // 2. Index ekle
            try {
                $pdo->exec("CREATE INDEX idx_instagram_id ON customers(instagram_id)");
                echo "<div class='success'>✅ Index eklendi</div>";
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'duplicate') !== false) {
                    echo "<div class='info'>ℹ️ Index zaten mevcut</div>";
                } else {
                    echo "<div class='warning'>⚠️ Index hatası: " . $e->getMessage() . "</div>";
                }
            }
            
            echo "<p style='margin-top: 20px;'><strong>2️⃣ Webhook dosyası hazır</strong></p>";
            echo "<div class='success'>✅ api/webhook-instagram.php oluşturuldu</div>";
            
            echo "<p style='margin-top: 20px;'><strong>3️⃣ Fonksiyonlar eklendi</strong></p>";
            echo "<div class='success'>✅ getCustomerByInstagramId() fonksiyonu eklendi</div>";
            
            echo "</div>";
            
            echo "<div class='success'>";
            echo "<h3>✅ Kurulum Tamamlandı!</h3>";
            echo "<p style='margin-top: 10px;'>Şimdi Instagram Business hesabınızı bağlayabilirsiniz.</p>";
            echo "</div>";
            
            echo "<div style='text-align: center; margin-top: 30px;'>";
            echo "<a href='instagram-setup-guide.php' class='btn'>📖 Kurulum Rehberine Git</a>";
            echo "<a href='index.php' class='btn' style='background: #6c757d;'>🏠 Ana Sayfa</a>";
            echo "</div>";
            
        } else {
        ?>

        <div class="info">
            <strong>📋 Instagram Entegrasyonu Nedir?</strong>
            <p style="margin-top: 10px;">
                Instagram Direct Messages (DM) üzerinden gelen müşteri mesajlarını CRM'de yönetebilirsiniz.
                Facebook Messenger gibi, tüm Instagram mesajları tek bir panelde toplanır.
            </p>
        </div>

        <div class="step">
            <h3>✨ Özellikler</h3>
            <ul style="margin-left: 20px; line-height: 2;">
                <li>✅ Instagram DM'lerini CRM'de görüntüleme</li>
                <li>✅ CRM'den Instagram'a cevap gönderme</li>
                <li>✅ Otomatik müşteri kaydı</li>
                <li>✅ Kullanıcı adı ve profil bilgisi çekme</li>
                <li>✅ Sohbet geçmişi saklama</li>
                <li>✅ Çoklu ajan desteği</li>
            </ul>
        </div>

        <div class="warning">
            <strong>⚠️ Gereksinimler:</strong>
            <ul style="margin-left: 20px; margin-top: 10px;">
                <li>Instagram Business veya Creator hesabı</li>
                <li>Instagram hesabı bir Facebook Page'e bağlı olmalı</li>
                <li>Facebook App'te Instagram Messaging ürünü eklenmiş olmalı</li>
                <li><code>instagram_manage_messages</code> izni (App Review gerekli)</li>
                <li><code>pages_messaging</code> izni (App Review gerekli)</li>
            </ul>
        </div>

        <div class="step">
            <h3>🚀 Kurulum Adımları</h3>
            <ol style="margin-left: 20px; line-height: 2;">
                <li><strong>Veritabanını güncelle</strong> (Bu sayfa ile)</li>
                <li><strong>Instagram Business hesabını bağla</strong></li>
                <li><strong>Webhook'u ayarla</strong></li>
                <li><strong>App Review başvurusu yap</strong></li>
                <li><strong>Test et ve kullan</strong></li>
            </ol>
        </div>

        <form method="POST" style="text-align: center; margin-top: 40px;">
            <button type="submit" name="install" value="yes" class="btn">
                🚀 Instagram Entegrasyonunu Kur
            </button>
        </form>

        <div class="info" style="margin-top: 30px;">
            <strong>💡 Not:</strong> Kurulum sonrası detaylı rehber sayfasına yönlendirileceksiniz.
            Facebook App Review süreci 3-7 iş günü sürebilir.
        </div>

        <?php } ?>
    </div>
</body>
</html>

