<?php
/**
 * Encryption Test Script
 * Şifreleme fonksiyonlarının çalışıp çalışmadığını test eder
 */

require_once __DIR__ . '/includes/encryption.php';
require_once __DIR__ . '/config/database.php';

echo "<!DOCTYPE html>\n";
echo "<html><head><title>Encryption Test</title></head><body>\n";
echo "<h1>Encryption Test</h1>\n";

// Test 1: Şifreleme/Çözme
echo "<h2>Test 1: Şifreleme ve Çözme</h2>\n";
$testData = "Bu bir test mesajıdır!";
echo "<p><strong>Orijinal:</strong> $testData</p>\n";

$encrypted = encryptData($testData);
echo "<p><strong>Şifrelenmiş:</strong> $encrypted</p>\n";

$decrypted = decryptData($encrypted);
echo "<p><strong>Çözülmüş:</strong> $decrypted</p>\n";

if ($testData === $decrypted) {
    echo "<p style='color: green;'><strong>✅ Test 1 BAŞARILI</strong></p>\n";
} else {
    echo "<p style='color: red;'><strong>❌ Test 1 BAŞARISIZ</strong></p>\n";
}

// Test 2: Veritabanına kaydetme
echo "<h2>Test 2: Veritabanına Kaydetme</h2>\n";
$testKey = 'test_encryption_key';
$testValue = 'test_secret_value_' . time();

$saved = saveSetting($pdo, $testKey, $testValue, 'string', 'Test encryption setting', true);
if ($saved) {
    echo "<p style='color: green;'><strong>✅ Kaydetme BAŞARILI</strong></p>\n";
    
    // Test 3: Veritabanından okuma
    echo "<h2>Test 3: Veritabanından Okuma</h2>\n";
    $retrieved = getSetting($pdo, $testKey, null, true);
    echo "<p><strong>Kaydedilen:</strong> $testValue</p>\n";
    echo "<p><strong>Okunan:</strong> $retrieved</p>\n";
    
    if ($testValue === $retrieved) {
        echo "<p style='color: green;'><strong>✅ Test 3 BAŞARILI</strong></p>\n";
    } else {
        echo "<p style='color: red;'><strong>❌ Test 3 BAŞARISIZ</strong></p>\n";
    }
    
    // Temizlik
    $pdo->exec("DELETE FROM settings WHERE `key` = '$testKey'");
    echo "<p><em>Test verisi temizlendi.</em></p>\n";
} else {
    echo "<p style='color: red;'><strong>❌ Test 2 BAŞARISIZ</strong></p>\n";
}

// Test 4: API ayarlarını yükleme
echo "<h2>Test 4: API Ayarlarını Yükleme</h2>\n";
try {
    $api_settings = loadApiSettings($pdo);
    echo "<p style='color: green;'><strong>✅ API ayarları yüklendi</strong></p>\n";
    echo "<pre>";
    echo "WhatsApp Phone Number ID: " . $api_settings['whatsapp']['phone_number_id'] . "\n";
    echo "Facebook App ID: " . $api_settings['facebook']['app_id'] . "\n";
    echo "</pre>";
} catch (Exception $e) {
    echo "<p style='color: red;'><strong>❌ Hata: " . $e->getMessage() . "</strong></p>\n";
}

echo "</body></html>";
?>
