<?php
/**
 * Facebook Mesaj Test - Manuel mesaj kaydetme
 */

require_once 'config/database.php';
require_once 'includes/functions.php';

echo "<h1>Facebook Mesaj Test</h1>";

// Test: Facebook müşterisi var mı?
$stmt = $pdo->prepare("SELECT * FROM customers WHERE facebook_id IS NOT NULL LIMIT 1");
$stmt->execute();
$customer = $stmt->fetch();

if (!$customer) {
    echo "<p style='color: red;'>❌ Facebook müşterisi bulunamadı!</p>";
    echo "<p>Önce Facebook'tan mesaj gönder veya manuel müşteri oluştur.</p>";
    exit;
}

echo "<p>✅ Facebook müşterisi bulundu: <strong>" . htmlspecialchars($customer['name']) . "</strong> (ID: " . $customer['id'] . ")</p>";

// Test: Sohbet var mı?
$conversation = getConversationByCustomer($customer['id'], 'facebook');

if (!$conversation) {
    echo "<p style='color: orange;'>⚠️ Sohbet bulunamadı, oluşturuluyor...</p>";
    
    // Aktif agent bul
    $stmt = $pdo->prepare("SELECT id FROM users WHERE status = 'active' LIMIT 1");
    $stmt->execute();
    $user = $stmt->fetch();
    
    if (!$user) {
        echo "<p style='color: red;'>❌ Aktif kullanıcı bulunamadı!</p>";
        exit;
    }
    
    $conversation_id = createConversation([
        'customer_id' => $customer['id'],
        'assigned_to' => $user['id'],
        'status' => 'active',
        'platform' => 'facebook'
    ]);
    
    $conversation = getConversationById($conversation_id);
    echo "<p>✅ Sohbet oluşturuldu: ID " . $conversation_id . "</p>";
} else {
    echo "<p>✅ Sohbet bulundu: ID " . $conversation['id'] . "</p>";
}

// Test mesajı kaydet
$testMessage = "Test mesajı - " . date('H:i:s');
$messageId = saveMessage([
    'conversation_id' => $conversation['id'],
    'sender_id' => null,
    'content' => $testMessage,
    'sender_type' => 'customer',
    'whatsapp_message_id' => 'test_' . time()
]);

echo "<p>✅ Test mesajı kaydedildi: ID " . $messageId . "</p>";
echo "<p><strong>Mesaj:</strong> " . htmlspecialchars($testMessage) . "</p>";

// Mesajları göster
$messages = getMessagesByConversation($conversation['id']);
echo "<h2>Sohbetteki Mesajlar (" . count($messages) . "):</h2>";
echo "<ul>";
foreach ($messages as $msg) {
    $style = $msg['sender_type'] === 'agent' ? 'color: blue;' : 'color: green;';
    echo "<li style='$style'><strong>" . htmlspecialchars($msg['sender_type']) . ":</strong> " . htmlspecialchars($msg['content']) . " <small>(" . $msg['created_at'] . ")</small></li>";
}
echo "</ul>";

echo "<hr>";
echo "<p><a href='index.php'>← Ana Sayfaya Dön</a></p>";
?>

