<?php
/**
 * Facebook Webhook Advanced Diagnostics
 */

echo "<h2>Facebook Webhook İleri Seviye Tanılama</h2>";
echo "<hr>";

require_once 'config/database.php';
require_once 'includes/functions.php';

// 1. Subscription kontrolü
echo "<h3>1. Webhook Subscription Kontrolü</h3>";
echo "<p>Facebook'ta şu subscription fields'ların seçili olması gerekiyor:</p>";
echo "<ul>";
echo "<li>✅ messages</li>";
echo "<li>✅ messaging_postbacks</li>";
echo "</ul>";

echo "<hr>";

// 2. Page Access Token testi
echo "<h3>2. Page Access Token Testi</h3>";
if (isset($facebook_config['page_access_token']) && !empty($facebook_config['page_access_token'])) {
    $token = $facebook_config['page_access_token'];
    
    // Token'ı test et
    $testUrl = "https://graph.facebook.com/v18.0/me?access_token=" . $token;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $data = json_decode($response, true);
        echo "<p style='color:green'>✅ Page Access Token geçerli</p>";
        echo "<pre>" . json_encode($data, JSON_PRETTY_PRINT) . "</pre>";
    } else {
        echo "<p style='color:red'>❌ Page Access Token geçersiz veya süresi dolmuş!</p>";
        echo "<p>HTTP Code: $httpCode</p>";
        echo "<p>Response: " . htmlspecialchars($response) . "</p>";
        echo "<div style='background:#fff3cd; padding:10px; margin:10px 0'>";
        echo "<strong>Çözüm:</strong> Meta for Developers'da yeni bir Page Access Token oluşturun.";
        echo "</div>";
    }
} else {
    echo "<p style='color:red'>❌ Page Access Token bulunamadı!</p>";
}

echo "<hr>";

// 3. Webhook erişilebilirlik testi
echo "<h3>3. Webhook Erişilebilirlik Testi</h3>";
$webhookUrl = 'https://profaj.co/multicrm/api/webhook-facebook.php';

// GET testi (verification)
$testUrl = $webhookUrl . '?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=TESTCHALLENGE123';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($httpCode === 200 && $response === 'TESTCHALLENGE123') {
    echo "<p style='color:green'>✅ Webhook verification çalışıyor</p>";
} else {
    echo "<p style='color:red'>❌ Webhook verification başarısız!</p>";
    echo "<p>HTTP Code: $httpCode</p>";
    echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    if ($error) {
        echo "<p>Error: " . htmlspecialchars($error) . "</p>";
    }
}

echo "<hr>";

// 4. Log dizini yazılabilir mi?
echo "<h3>4. Log Dizini Kontrolü</h3>";
$logDir = __DIR__ . '/logs';
if (is_dir($logDir)) {
    if (is_writable($logDir)) {
        echo "<p style='color:green'>✅ Log dizini yazılabilir</p>";
    } else {
        echo "<p style='color:red'>❌ Log dizini yazılabilir değil!</p>";
        echo "<p>Dizin: $logDir</p>";
        echo "<p><strong>Çözüm:</strong> <code>chmod 755 logs</code> komutunu çalıştırın</p>";
    }
} else {
    echo "<p style='color:orange'>⚠️ Log dizini yok, oluşturuluyor...</p>";
    if (mkdir($logDir, 0755, true)) {
        echo "<p style='color:green'>✅ Log dizini oluşturuldu</p>";
    } else {
        echo "<p style='color:red'>❌ Log dizini oluşturulamadı!</p>";
    }
}

echo "<hr>";

// 5. Manuel POST testi
echo "<h3>5. Manuel Webhook POST Testi</h3>";
echo "<p>Webhook'a manuel test mesajı göndermek için:</p>";

if (isset($_GET['send_test_post'])) {
    $testData = [
        'object' => 'page',
        'entry' => [
            [
                'id' => 'TEST_PAGE_ID',
                'time' => time() * 1000,
                'messaging' => [
                    [
                        'sender' => ['id' => 'TEST_USER_123'],
                        'recipient' => ['id' => 'TEST_PAGE_ID'],
                        'timestamp' => time() * 1000,
                        'message' => [
                            'mid' => 'TEST_MID_' . time(),
                            'text' => 'Test mesajı - ' . date('H:i:s')
                        ]
                    ]
                ]
            ]
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $webhookUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "<h4>Test Sonucu:</h4>";
    if ($httpCode === 200) {
        echo "<p style='color:green'>✅ POST isteği başarılı</p>";
        echo "<p>Response: " . htmlspecialchars($response) . "</p>";
        
        // Log dosyasını kontrol et
        $todayLog = $logDir . '/facebook_webhook_' . date('Y-m-d') . '.log';
        if (file_exists($todayLog)) {
            echo "<p style='color:green'>✅ Log dosyası oluşturuldu!</p>";
            echo "<h4>Son Log Satırları:</h4>";
            $lines = file($todayLog);
            $lastLines = array_slice($lines, -20);
            echo "<pre style='background:#f5f5f5; padding:10px'>";
            echo htmlspecialchars(implode('', $lastLines));
            echo "</pre>";
        } else {
            echo "<p style='color:red'>❌ Log dosyası oluşturulmadı!</p>";
        }
    } else {
        echo "<p style='color:red'>❌ POST isteği başarısız</p>";
        echo "<p>HTTP Code: $httpCode</p>";
    }
}

echo "<p><a href='?send_test_post=1' style='display:inline-block; padding:10px 20px; background:#007bff; color:white; text-decoration:none; border-radius:5px'>Test POST Gönder</a></p>";

echo "<hr>";

// 6. Facebook'ta kontrol edilmesi gerekenler
echo "<h3>6. Facebook Developer Console Kontrol Listesi</h3>";
echo "<div style='background:#e7f3ff; padding:15px; border-left:4px solid #2196F3'>";
echo "<h4>Meta for Developers'da kontrol edin:</h4>";
echo "<ol>";
echo "<li><strong>Messenger > Settings > Webhooks</strong>";
echo "<ul>";
echo "<li>Callback URL: <code>https://profaj.co/multicrm/api/webhook-facebook.php</code></li>";
echo "<li>Verify Token: <code>profaj_whatsapp_2024</code></li>";
echo "<li>Status: <strong>Active</strong> olmalı</li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>Subscription Fields</strong> (mutlaka seçili olmalı):";
echo "<ul>";
echo "<li>✅ messages</li>";
echo "<li>✅ messaging_postbacks</li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>Page Subscription</strong>";
echo "<ul>";
echo "<li>Sayfanız webhook'a subscribe edilmiş olmalı</li>";
echo "<li>Subscribe butonuna tıklayın</li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>App Review</strong>";
echo "<ul>";
echo "<li>Test modunda mı yoksa live modda mı?</li>";
echo "<li>Test modundaysa sadece test kullanıcıları mesaj gönderebilir</li>";
echo "</ul>";
echo "</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<p><a href='test-facebook-webhook.php'>Basit Test Sayfasına Dön</a> | <a href='index.php'>Ana Sayfa</a></p>";
?>
