<?php
header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔍 FACEBOOK WEBHOOK MANUEL TEST\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// Test 1: Webhook dosyası erişilebilir mi?
echo "1️⃣  WEBHOOK DOSYASI ERİŞİM TESTİ:\n";
echo "───────────────────────────────────────────────────────────\n";

$webhookUrl = 'https://profaj.co/multicrm/api/webhook-facebook.php';
$verifyUrl = $webhookUrl . '?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123';

echo "Webhook URL: $webhookUrl\n";
echo "Verify URL: $verifyUrl\n\n";

$ch = curl_init($verifyUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Status: $httpCode\n";
echo "Response: $response\n";

if ($httpCode === 200 && $response === 'test123') {
    echo "✅ Webhook doğrulama çalışıyor!\n";
} else {
    echo "❌ Webhook doğrulama çalışmıyor!\n";
}

// Test 2: Config dosyası yükleniyor mu?
echo "\n2️⃣  CONFIG DOSYASI TESTİ:\n";
echo "───────────────────────────────────────────────────────────\n";

if (file_exists('config/facebook.php')) {
    require_once 'config/facebook.php';
    
    if (isset($facebook_config)) {
        echo "✅ Config dosyası yüklendi\n";
        echo "   App ID: " . substr($facebook_config['app_id'], 0, 10) . "...\n";
        echo "   Token uzunluğu: " . strlen($facebook_config['page_access_token']) . " karakter\n";
        
        // Token geçerli mi test et
        echo "\n3️⃣  PAGE ACCESS TOKEN TESTİ:\n";
        echo "───────────────────────────────────────────────────────────\n";
        
        $tokenTestUrl = "https://graph.facebook.com/v18.0/me?access_token=" . $facebook_config['page_access_token'];
        
        $ch = curl_init($tokenTestUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $tokenResponse = curl_exec($ch);
        $tokenHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        echo "HTTP Status: $tokenHttpCode\n";
        
        if ($tokenHttpCode === 200) {
            $data = json_decode($tokenResponse, true);
            echo "✅ Token geçerli!\n";
            echo "   Page ID: " . ($data['id'] ?? 'N/A') . "\n";
            echo "   Page Name: " . ($data['name'] ?? 'N/A') . "\n";
        } else {
            echo "❌ Token geçersiz veya süresi dolmuş!\n";
            echo "   Response: $tokenResponse\n";
        }
    } else {
        echo "❌ \$facebook_config tanımlı değil\n";
    }
} else {
    echo "❌ config/facebook.php bulunamadı\n";
}

echo "\n4️⃣  FACEBOOK DEVELOPER CONSOLE KONTROL:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "Aşağıdaki kontrolleri Facebook Developer Console'da yapın:\n\n";

echo "A) WEBHOOK URL KONTROLÜ:\n";
echo "   □ Messenger → Settings → Webhooks\n";
echo "   □ Callback URL eklenmiş mi?\n";
echo "   □ Yeşil tik var mı? ✅\n";
echo "   □ URL: https://profaj.co/multicrm/api/webhook-facebook.php\n";
echo "   □ Verify Token: profaj_whatsapp_2024\n\n";

echo "B) SUBSCRIBE FIELDS KONTROLÜ:\n";
echo "   □ messages seçili mi?\n";
echo "   □ messaging_postbacks seçili mi?\n";
echo "   □ message_deliveries seçili mi?\n";
echo "   □ message_reads seçili mi?\n\n";

echo "C) SAYFA SUBSCRIBE KONTROLÜ:\n";
echo "   □ Webhooks bölümünde sayfanız listeleniyor mu?\n";
echo "   □ Sayfanın yanında 'Subscribed' yazıyor mu?\n";
echo "   □ Subscribe butonu varsa tıklandı mı?\n\n";

echo "D) TEST WEBHOOK:\n";
echo "   □ Webhooks bölümünde 'Test' butonu var mı?\n";
echo "   □ Test butonuna tıklandı mı?\n";
echo "   □ 'messages' event seçildi mi?\n";
echo "   □ 'Send to My Server' tıklandı mı?\n";
echo "   □ Success mesajı geldi mi?\n\n";

echo "E) UYGULAMA MODU:\n";
echo "   □ Sol üst köşede 'App Mode' ne diyor?\n";
echo "   □ Development modda mı?\n";
echo "   □ Siz page admin misiniz?\n\n";

echo "\n5️⃣  MANUEL TEST ADIMLARI:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "1. Facebook Developer Console → Webhooks → Test\n";
echo "2. 'messages' event seç\n";
echo "3. 'Send to My Server' tıkla\n";
echo "4. Bu sayfayı yenile:\n";
echo "   https://profaj.co/multicrm/view-facebook-logs.php\n";
echo "5. Log dosyası oluştu mu kontrol et\n\n";

echo "\n6️⃣  OLASI SORUNLAR:\n";
echo "───────────────────────────────────────────────────────────\n";
echo "❌ Webhook URL Facebook'ta yanlış girilmiş\n";
echo "❌ Verify Token eşleşmiyor\n";
echo "❌ Subscribe fields seçilmemiş\n";
echo "❌ Sayfa subscribe edilmemiş (en yaygın sorun!)\n";
echo "❌ Page Access Token süresi dolmuş\n";
echo "❌ Uygulama Development modda ve siz admin değilsiniz\n";
echo "❌ Facebook'un webhook çağrıları sunucuya ulaşamıyor\n\n";

echo "═══════════════════════════════════════════════════════════\n";
echo "📸 EKRAN GÖRÜNTÜSÜ İSTEĞİ:\n";
echo "═══════════════════════════════════════════════════════════\n";
echo "Facebook Developer Console'dan şu bölümlerin ekran\n";
echo "görüntüsünü alabilir misiniz?\n\n";
echo "1. Messenger → Settings → Webhooks bölümü\n";
echo "2. Subscribe to fields listesi\n";
echo "3. Sayfanızın subscribe durumu\n\n";
echo "Bu sayede sorunu daha hızlı tespit edebiliriz.\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

