<?php
// Facebook entegrasyonunu test et
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

require_once 'config/database.php';
require_once 'includes/functions.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facebook Test - MultiCRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { background: #f5f5f5; padding: 20px; }
        .test-card { background: white; border-radius: 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .test-item { padding: 15px; border-left: 4px solid #ccc; margin-bottom: 10px; }
        .test-item.success { border-left-color: #28a745; background: #f0fff4; }
        .test-item.error { border-left-color: #dc3545; background: #fff5f5; }
        .test-item.warning { border-left-color: #ffc107; background: #fffbf0; }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4">
            <i class="fab fa-facebook"></i> Facebook Entegrasyonu Test
        </h1>

        <!-- Facebook Config -->
        <div class="test-card">
            <h3><i class="fas fa-cogs"></i> Facebook Config Kontrolü</h3>
            <hr>
            
            <?php
            if (isset($facebook_config)) {
                echo '<div class="test-item success">';
                echo '<strong>✓ Facebook config yüklendi</strong>';
                echo '<ul class="mt-3 mb-0">';
                echo '<li>App ID: <code>' . $facebook_config['app_id'] . '</code></li>';
                echo '<li>API Version: <code>' . $facebook_config['api_version'] . '</code></li>';
                echo '<li>Verify Token: <code>' . substr($facebook_config['verify_token'], 0, 20) . '...</code></li>';
                echo '<li>Page Access Token: <code>' . substr($facebook_config['page_access_token'], 0, 30) . '...</code></li>';
                echo '<li>Webhook URL: <code>' . $facebook_config['webhook_url'] . '</code></li>';
                echo '</ul>';
                echo '</div>';
            } else {
                echo '<div class="test-item error">';
                echo '<strong>✗ Facebook config bulunamadı</strong>';
                echo '<p class="mb-0 mt-2">config/database.php dosyasında $facebook_config tanımlı değil!</p>';
                echo '</div>';
            }
            ?>
        </div>

        <!-- Webhook Test -->
        <div class="test-card">
            <h3><i class="fas fa-webhook"></i> Webhook Doğrulama</h3>
            <hr>
            
            <p>Webhook test URL'lerini aşağıda bulabilirsiniz:</p>
            <p><code style="background: #f5f5f5; padding: 10px; border-radius: 5px;">
                <a href="api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=<?php echo $facebook_config['verify_token'] ?? 'N/A'; ?>&hub.challenge=test123" target="_blank">
                    api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=<?php echo $facebook_config['verify_token'] ?? 'N/A'; ?>&hub.challenge=test123
                </a>
            </code></p>
            
            <div class="alert alert-info mt-3">
                <strong>Not:</strong> Eğer "test123" döndürürse webhook doğrulama başarılı demektir.
            </div>
        </div>

        <!-- Database Check -->
        <div class="test-card">
            <h3><i class="fas fa-database"></i> Veritabanı Kontrolü</h3>
            <hr>
            
            <?php
            // Veritabanı kontrolü
            try {
                $stmt = $pdo->query("DESCRIBE messages");
                $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
                
                $checks = [
                    'content' => in_array('content', $columns),
                    'sender_type' => in_array('sender_type', $columns),
                    'whatsapp_message_id' => in_array('whatsapp_message_id', $columns)
                ];
                
                $stmt = $pdo->query("DESCRIBE conversations");
                $columns2 = $stmt->fetchAll(PDO::FETCH_COLUMN);
                $checks['platform'] = in_array('platform', $columns2);
                
                $stmt = $pdo->query("DESCRIBE customers");
                $columns3 = $stmt->fetchAll(PDO::FETCH_COLUMN);
                $checks['facebook_id'] = in_array('facebook_id', $columns3);
                
                foreach ($checks as $name => $exists) {
                    if ($exists) {
                        echo '<div class="test-item success">';
                        echo '<strong>✓ ' . $name . ' sütunu mevcut</strong>';
                        echo '</div>';
                    } else {
                        echo '<div class="test-item error">';
                        echo '<strong>✗ ' . $name . ' sütunu eksik</strong>';
                        echo '<p class="mb-0 mt-2">Veritabanı Güncelleme Sihirbazını çalıştırın!</p>';
                        echo '</div>';
                    }
                }
            } catch (Exception $e) {
                echo '<div class="test-item error">';
                echo '<strong>✗ Veritabanı hatası: ' . $e->getMessage() . '</strong>';
                echo '</div>';
            }
            ?>
        </div>

        <!-- Facebook Mesajları -->
        <div class="test-card">
            <h3><i class="fas fa-comments"></i> Alınan Facebook Mesajları</h3>
            <hr>
            
            <?php
            try {
                $stmt = $pdo->prepare("
                    SELECT m.*, c.id as conversation_id, cu.name, cu.facebook_id
                    FROM messages m
                    LEFT JOIN conversations c ON m.conversation_id = c.id
                    LEFT JOIN customers cu ON c.customer_id = cu.id
                    WHERE cu.facebook_id IS NOT NULL OR c.platform = 'facebook'
                    ORDER BY m.created_at DESC
                    LIMIT 10
                ");
                $stmt->execute();
                $messages = $stmt->fetchAll();
                
                if (count($messages) > 0) {
                    echo '<table class="table">';
                    echo '<thead><tr><th>Müşteri</th><th>Facebook ID</th><th>Mesaj</th><th>Zaman</th></tr></thead>';
                    echo '<tbody>';
                    foreach ($messages as $msg) {
                        echo '<tr>';
                        echo '<td>' . ($msg['name'] ?? 'N/A') . '</td>';
                        echo '<td><code>' . substr($msg['facebook_id'] ?? 'N/A', 0, 15) . '...</code></td>';
                        echo '<td>' . substr($msg['content'] ?? 'N/A', 0, 50) . '...</td>';
                        echo '<td><small>' . $msg['created_at'] . '</small></td>';
                        echo '</tr>';
                    }
                    echo '</tbody>';
                    echo '</table>';
                } else {
                    echo '<div class="alert alert-warning">';
                    echo '<strong>⚠️ Henüz Facebook mesajı alınmamış.</strong><br>';
                    echo 'Facebook Developer Console\'da webhook\'u kontrol edin ve test mesajı gönderin.';
                    echo '</div>';
                }
            } catch (Exception $e) {
                echo '<div class="alert alert-danger">';
                echo '<strong>✗ Hata:</strong> ' . $e->getMessage();
                echo '</div>';
            }
            ?>
        </div>

        <!-- Webhook Kontrol -->
        <div class="test-card">
            <h3><i class="fas fa-check-circle"></i> Webhook Setup Kontrol Listesi</h3>
            <hr>
            
            <div class="alert alert-info">
                <strong>✓ Webhook URL:</strong><br>
                <code>https://profaj.co/multicrm/api/webhook-facebook.php</code>
            </div>
            
            <div class="alert alert-info">
                <strong>✓ Verify Token:</strong><br>
                <code>profaj_whatsapp_2024</code>
            </div>
            
            <h5>Ayarlanması Gerekenler:</h5>
            <ul>
                <li>✓ Facebook Developer Console → App Settings → Webhooks</li>
                <li>✓ Webhook URL yukarıdaki URL olmalı</li>
                <li>✓ Verify Token yukarıdaki token olmalı</li>
                <li>✓ Subscribe Fields: messages, messaging_postbacks</li>
                <li>✓ SSL sertifikası geçerli olmalı (https://)</li>
                <li>✓ Webhook aktif olmalı</li>
            </ul>
        </div>

        <div class="mb-4">
            <a href="index.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Ana Sayfaya Dön
            </a>
        </div>
    </div>
</body>
</html>
