<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SSE Test - MultiCRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f5f5f5;
            padding: 20px;
        }
        .test-container {
            max-width: 900px;
            margin: 0 auto;
        }
        .log-box {
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            max-height: 600px;
            overflow-y: auto;
            font-family: monospace;
            font-size: 12px;
        }
        .log-entry {
            padding: 8px;
            border-bottom: 1px solid #eee;
            margin-bottom: 8px;
        }
        .log-entry.info {
            color: #0066cc;
        }
        .log-entry.success {
            color: #28a745;
        }
        .log-entry.error {
            color: #dc3545;
        }
        .log-entry.warning {
            color: #ff9800;
        }
        .status {
            font-weight: bold;
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .status.connected {
            background: #d4edda;
            color: #155724;
        }
        .status.disconnected {
            background: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="test-container">
        <h1 class="mb-4">
            <i class="fas fa-wifi"></i> SSE Real-time Test
        </h1>

        <div id="status" class="status disconnected">
            <i class="fas fa-circle" style="font-size: 10px;"></i>
            Bağlantı: <span id="status-text">Yok</span>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fas fa-terminal"></i> Event Log
                </h5>
            </div>
            <div class="log-box" id="log">
                <div class="log-entry info">
                    <i class="fas fa-info-circle"></i> SSE bağlantısı başlatılıyor...
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <button class="btn btn-primary btn-block" onclick="startSSE()" style="width: 100%;">
                    <i class="fas fa-play"></i> Başlat
                </button>
            </div>
            <div class="col-md-6">
                <button class="btn btn-danger btn-block" onclick="stopSSE()" style="width: 100%;">
                    <i class="fas fa-stop"></i> Durdur
                </button>
            </div>
        </div>

        <div class="mt-4">
            <h5>Bilgiler:</h5>
            <ul>
                <li><strong>URL:</strong> <code>api/stream-messages.php</code></li>
                <li><strong>Timeout:</strong> 30 dakika</li>
                <li><strong>Heartbeat:</strong> Her 5 saniye</li>
                <li><strong>Event Types:</strong> message, conversation</li>
            </ul>
        </div>
    </div>

    <script>
        let eventSource = null;
        const logBox = document.getElementById('log');
        const statusEl = document.getElementById('status');
        const statusText = document.getElementById('status-text');

        function addLog(message, type = 'info') {
            const entry = document.createElement('div');
            entry.className = `log-entry ${type}`;
            entry.innerHTML = `[${new Date().toLocaleTimeString()}] ${message}`;
            logBox.appendChild(entry);
            logBox.scrollTop = logBox.scrollHeight;
        }

        function setStatus(connected) {
            if (connected) {
                statusEl.className = 'status connected';
                statusText.textContent = 'Bağlı ✓';
            } else {
                statusEl.className = 'status disconnected';
                statusText.textContent = 'Kesildi ✗';
            }
        }

        function startSSE() {
            if (eventSource) {
                addLog('SSE zaten çalışıyor!', 'warning');
                return;
            }

            addLog('SSE bağlantısı açılıyor...', 'info');
            eventSource = new EventSource('api/stream-messages.php');

            eventSource.onopen = () => {
                addLog('✓ SSE bağlantısı açıldı', 'success');
                setStatus(true);
            };

            eventSource.onerror = (e) => {
                if (e.readyState === EventSource.CLOSED) {
                    addLog('✗ SSE bağlantısı kapatıldı', 'error');
                    setStatus(false);
                    eventSource = null;
                }
            };

            eventSource.addEventListener('message', (event) => {
                try {
                    const data = JSON.parse(event.data);
                    addLog(`Yeni Mesaj: ${data.message.customer_name} - ${data.message.message_text}`, 'success');
                } catch (e) {
                    addLog(`Mesaj: ${event.data}`, 'info');
                }
            });

            eventSource.addEventListener('conversation', (event) => {
                try {
                    const data = JSON.parse(event.data);
                    addLog(`Yeni Sohbet: ${data.conversation.name}`, 'success');
                } catch (e) {
                    addLog(`Sohbet: ${event.data}`, 'info');
                }
            });
        }

        function stopSSE() {
            if (!eventSource) {
                addLog('SSE çalışmıyor!', 'warning');
                return;
            }

            eventSource.close();
            eventSource = null;
            addLog('SSE bağlantısı kapatıldı', 'warning');
            setStatus(false);
        }

        // Sayfa yüklendiğinde otomatik başlat
        window.addEventListener('DOMContentLoaded', () => {
            startSSE();
        });

        // Sayfa kapatılırken kapat
        window.addEventListener('beforeunload', () => {
            if (eventSource) {
                eventSource.close();
            }
        });
    </script>
</body>
</html>
