# 🚀 MultiCRM v2.0 - Kurulum Talimatları

## ✅ Tamamlanan Özellikler

- ✅ **Unified Inbox** - WhatsApp ve Facebook Messenger mesajlarını tek yerden yönetin
- ✅ **Otomatik Mesaj Atama** - Round-robin ve yük dengeli atama algoritmaları
- ✅ **Platform Filtreleme** - Kanalları filtreleyin (Tümü, WhatsApp, Messenger)
- ✅ **Atanmamış Mesajlar** - Admin/Supervisor için özel yönetim paneli
- ✅ **Sohbet Transferi** - Ajanlar arası kolay transfer
- ✅ **Rol Bazlı Yetkilendirme** - Admin, Supervisor, Agent rolleri
- ✅ **Performans Takibi** - Yanıt süreleri ve istatistikler
- ✅ **Modern UI** - Chatwoot-benzeri temiz tasarım

---

## 📋 Kurulum Adımları

### 1. Veritabanı Migration'ını Çalıştırın

Tarayıcınızda şu adresi açın:

```
https://profaj.co/multicrm/install/run-migration.php
```

Bu işlem:
- 8 yeni tablo oluşturur
- Mevcut tablolara yeni kolonlar ekler
- Varsayılan ayarları yapılandırır
- Kullanıcılar için availability kayıtları oluşturur

> ⚠️ **ÖNEMLİ:** Migration'dan önce veritabanı yedeği alın!

### 2. Sistemi Test Edin

Migration tamamlandıktan sonra:

1. **Ana sayfaya gidin:** `https://profaj.co/multicrm/`
2. **Giriş yapın:** Admin hesabınızla
3. **Platform filtrelerini test edin:** Tümü, WhatsApp, Messenger
4. **Test mesajı gönderin:** WhatsApp veya Facebook'tan

---

## 🎯 Yeni Özellikler Nasıl Kullanılır?

### Platform Filtreleme

Ana sayfada üstte 3 buton göreceksiniz:
- **Tümü** - Tüm kanallardan mesajlar
- **WhatsApp** - Sadece WhatsApp
- **Messenger** - Sadece Facebook Messenger

### Atanmamış Mesajlar (Admin/Supervisor)

Sarı arka planlı bölümde atanmamış mesajları görebilirsiniz:
1. Atanmamış mesaja tıklayın
2. "Sohbeti Ata" butonuna tıklayın
3. Bir ajan seçin
4. Atama tamamlandı!

### Sohbet Transferi

1. Bir sohbet seçin
2. "Transfer Et" butonuna tıklayın
3. Hedef ajanı seçin
4. Transfer nedenini yazın (opsiyonel)
5. Onayla

---

## 🔧 Ayarlar

Varsayılan ayarlar:
- ✅ Otomatik atama: **Açık**
- ✅ Atama algoritması: **Round-robin**
- ✅ Maksimum sohbet/ajan: **10**

Ayarları değiştirmek için `settings` tablosunu kullanın.

---

## 📊 Yeni Veritabanı Tabloları

- `assignment_rules` - Atama kuralları
- `user_permissions` - Kullanıcı yetkileri
- `activity_logs` - Aktivite kayıtları
- `conversation_transfers` - Transfer geçmişi
- `agent_availability` - Ajan durumları
- `agent_statistics` - Performans metrikleri

---

## 🐛 Sorun Giderme

### Migration Hataları

**"Duplicate column" hatası:**
- Normal, kolon zaten mevcut. Devam edebilirsiniz.

**"Table already exists" hatası:**
- Normal, tablo zaten mevcut. Devam edebilirsiniz.

### Atama Çalışmıyor

1. Log dosyalarını kontrol edin:
   - `logs/assignment_*.log`
   - `logs/facebook_webhook_*.log`
   - `logs/app_*.log`

2. Agent availability'yi kontrol edin:
```sql
SELECT * FROM agent_availability WHERE status = 'online';
```

3. Assignment rule'ları kontrol edin:
```sql
SELECT * FROM assignment_rules WHERE is_active = 1;
```

---

## 📞 Destek

Herhangi bir sorun yaşarsanız:
1. Log dosyalarını kontrol edin
2. Walkthrough.md dosyasını inceleyin
3. Veritabanı migration'ının başarılı olduğunu doğrulayın

---

## 🎉 Başarılı Kurulum!

Sistem artık hazır. Yeni özelliklerden yararlanabilirsiniz:

- ✅ Çok kanallı mesajlaşma
- ✅ Otomatik atama
- ✅ Gelişmiş yönetim
- ✅ Performans takibi

**İyi çalışmalar! 🚀**
